/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data.sort;

import java.util.stream.IntStream;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BitArray;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.common.util.FloatArray;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.FloatBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.search.sort.SortOrder;

public class DoubleFloatBucketedSort
implements Releasable {
    private final BigArrays bigArrays;
    private final SortOrder order;
    private final int bucketSize;
    private final BitArray heapMode;
    private DoubleArray values;
    private FloatArray extraValues;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DoubleFloatBucketedSort(BigArrays bigArrays, SortOrder order, int bucketSize) {
        this.bigArrays = bigArrays;
        this.order = order;
        this.bucketSize = bucketSize;
        this.heapMode = new BitArray(0L, bigArrays);
        boolean success = false;
        try {
            this.values = bigArrays.newDoubleArray(0L, false);
            this.extraValues = bigArrays.newFloatArray(0L, false);
            success = true;
        }
        finally {
            if (!success) {
                this.close();
            }
        }
    }

    public void collect(double value, float extraValue, int bucket) {
        long rootIndex = (long)bucket * (long)this.bucketSize;
        if (this.inHeapMode(bucket)) {
            if (this.betterThan(value, this.values.get(rootIndex), extraValue, this.extraValues.get(rootIndex))) {
                this.values.set(rootIndex, value);
                this.extraValues.set(rootIndex, extraValue);
                this.downHeap(rootIndex, 0, this.bucketSize);
            }
            return;
        }
        long requiredSize = rootIndex + (long)this.bucketSize;
        if (this.values.size() < requiredSize) {
            this.grow(bucket);
        }
        int next = this.getNextGatherOffset(rootIndex);
        assert (0 <= next && next < this.bucketSize) : "Expected next to be in the range of valid buckets [0 <= " + next + " < " + this.bucketSize + "]";
        long index = (long)next + rootIndex;
        this.values.set(index, value);
        this.extraValues.set(index, extraValue);
        if (next == 0) {
            this.heapMode.set((long)bucket);
            this.heapify(rootIndex, this.bucketSize);
        } else {
            this.setNextGatherOffset(rootIndex, next - 1);
        }
    }

    public SortOrder getOrder() {
        return this.order;
    }

    public int getBucketSize() {
        return this.bucketSize;
    }

    private Tuple<Long, Long> getBucketValuesIndexes(int bucket) {
        long rootIndex = (long)bucket * (long)this.bucketSize;
        if (rootIndex >= this.values.size()) {
            return Tuple.tuple((Object)0L, (Object)0L);
        }
        long start = this.inHeapMode(bucket) ? rootIndex : rootIndex + (long)this.getNextGatherOffset(rootIndex) + 1L;
        long end = rootIndex + (long)this.bucketSize;
        return Tuple.tuple((Object)start, (Object)end);
    }

    public void merge(int groupId, DoubleFloatBucketedSort other, int otherGroupId) {
        Tuple<Long, Long> otherBounds = other.getBucketValuesIndexes(otherGroupId);
        for (long i = ((Long)otherBounds.v1()).longValue(); i < (Long)otherBounds.v2(); ++i) {
            this.collect(other.values.get(i), other.extraValues.get(i), groupId);
        }
    }

    public void toBlocks(BlockFactory blockFactory, Block[] blocks, int offset, IntVector selected) {
        if (this.allSelectedGroupsAreEmpty(selected)) {
            Block constantNullBlock = blockFactory.newConstantNullBlock(selected.getPositionCount());
            constantNullBlock.incRef();
            blocks[offset] = constantNullBlock;
            blocks[offset + 1] = constantNullBlock;
            return;
        }
        try (DoubleBlock.Builder builder = blockFactory.newDoubleBlockBuilder(selected.getPositionCount());
             FloatBlock.Builder extraBuilder = blockFactory.newFloatBlockBuilder(selected.getPositionCount());){
            for (int s = 0; s < selected.getPositionCount(); ++s) {
                int bucket = selected.getInt(s);
                Tuple<Long, Long> bounds = this.getBucketValuesIndexes(bucket);
                Long rootIndex = (Long)bounds.v1();
                long size = (Long)bounds.v2() - (Long)bounds.v1();
                if (size == 0L) {
                    builder.appendNull();
                    extraBuilder.appendNull();
                    continue;
                }
                if (size == 1L) {
                    builder.appendDouble(this.values.get(rootIndex.longValue()));
                    extraBuilder.appendFloat(this.extraValues.get(rootIndex.longValue()));
                    continue;
                }
                if (!this.inHeapMode(bucket)) {
                    this.heapify(rootIndex, (int)size);
                }
                this.heapSort(rootIndex, (int)size);
                builder.beginPositionEntry();
                extraBuilder.beginPositionEntry();
                int i = 0;
                while ((long)i < size) {
                    builder.appendDouble(this.values.get(rootIndex + (long)i));
                    extraBuilder.appendFloat(this.extraValues.get(rootIndex + (long)i));
                    ++i;
                }
                builder.endPositionEntry();
                extraBuilder.endPositionEntry();
            }
            blocks[offset] = builder.build();
            blocks[offset + 1] = extraBuilder.build();
        }
    }

    private boolean allSelectedGroupsAreEmpty(IntVector selected) {
        return IntStream.range(0, selected.getPositionCount()).map(selected::getInt).noneMatch(bucket -> {
            Tuple<Long, Long> bounds = this.getBucketValuesIndexes(bucket);
            long size = (Long)bounds.v2() - (Long)bounds.v1();
            return size > 0L;
        });
    }

    private boolean inHeapMode(int bucket) {
        return this.heapMode.get((long)bucket);
    }

    private int getNextGatherOffset(long rootIndex) {
        return (int)this.values.get(rootIndex);
    }

    private void setNextGatherOffset(long rootIndex, int offset) {
        this.values.set(rootIndex, (double)offset);
    }

    private boolean betterThan(double lhs, double rhs, float lhsExtra, float rhsExtra) {
        int res = Double.compare(lhs, rhs);
        if (res != 0) {
            return this.getOrder().reverseMul() * res < 0;
        }
        res = Float.compare(lhsExtra, rhsExtra);
        return this.getOrder().reverseMul() * res < 0;
    }

    private void swap(long lhs, long rhs) {
        double tmp = this.values.get(lhs);
        this.values.set(lhs, this.values.get(rhs));
        this.values.set(rhs, tmp);
        float tmpExtra = this.extraValues.get(lhs);
        this.extraValues.set(lhs, this.extraValues.get(rhs));
        this.extraValues.set(rhs, tmpExtra);
    }

    private void grow(int bucket) {
        long oldMax = this.values.size();
        assert (oldMax % (long)this.bucketSize == 0L);
        long newSize = BigArrays.overSize((long)(((long)bucket + 1L) * (long)this.bucketSize), (int)2048, (int)8);
        newSize = (newSize + (long)this.bucketSize - 1L) / (long)this.bucketSize;
        this.values = this.bigArrays.resize(this.values, newSize * (long)this.bucketSize);
        this.extraValues = this.bigArrays.resize(this.extraValues, newSize * (long)this.bucketSize);
        this.fillGatherOffsets(oldMax);
    }

    private void fillGatherOffsets(long startingAt) {
        int nextOffset = this.getBucketSize() - 1;
        for (long bucketRoot = startingAt; bucketRoot < this.values.size(); bucketRoot += (long)this.getBucketSize()) {
            this.setNextGatherOffset(bucketRoot, nextOffset);
        }
    }

    private void heapify(long rootIndex, int heapSize) {
        int maxParent;
        for (int parent = maxParent = heapSize / 2 - 1; parent >= 0; --parent) {
            this.downHeap(rootIndex, parent, heapSize);
        }
    }

    private void heapSort(long rootIndex, int heapSize) {
        while (heapSize > 0) {
            this.swap(rootIndex, rootIndex + (long)heapSize - 1L);
            this.downHeap(rootIndex, 0, --heapSize);
        }
    }

    private void downHeap(long rootIndex, int parent, int heapSize) {
        while (true) {
            long parentIndex = rootIndex + (long)parent;
            int worst = parent;
            long worstIndex = parentIndex;
            int leftChild = parent * 2 + 1;
            long leftIndex = rootIndex + (long)leftChild;
            if (leftChild < heapSize) {
                if (this.betterThan(this.values.get(worstIndex), this.values.get(leftIndex), this.extraValues.get(worstIndex), this.extraValues.get(leftIndex))) {
                    worst = leftChild;
                    worstIndex = leftIndex;
                }
                int rightChild = leftChild + 1;
                long rightIndex = rootIndex + (long)rightChild;
                if (rightChild < heapSize && this.betterThan(this.values.get(worstIndex), this.values.get(rightIndex), this.extraValues.get(worstIndex), this.extraValues.get(rightIndex))) {
                    worst = rightChild;
                    worstIndex = rightIndex;
                }
            }
            if (worst == parent) break;
            this.swap(worstIndex, parentIndex);
            parent = worst;
        }
    }

    public final void close() {
        Releasables.close((Releasable[])new Releasable[]{this.values, this.extraValues, this.heapMode});
    }
}

