/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunction;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.TopDoubleDoubleAggregator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class TopDoubleDoubleAggregatorFunction
implements AggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("top", ElementType.DOUBLE), new IntermediateStateDesc("output", ElementType.DOUBLE));
    private final DriverContext driverContext;
    private final TopDoubleDoubleAggregator.SingleState state;
    private final List<Integer> channels;
    private final int limit;
    private final boolean ascending;

    public TopDoubleDoubleAggregatorFunction(DriverContext driverContext, List<Integer> channels, TopDoubleDoubleAggregator.SingleState state, int limit, boolean ascending) {
        this.driverContext = driverContext;
        this.channels = channels;
        this.state = state;
        this.limit = limit;
        this.ascending = ascending;
    }

    public static TopDoubleDoubleAggregatorFunction create(DriverContext driverContext, List<Integer> channels, int limit, boolean ascending) {
        return new TopDoubleDoubleAggregatorFunction(driverContext, channels, TopDoubleDoubleAggregator.initSingle(driverContext.bigArrays(), limit, ascending), limit, ascending);
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public void addRawInput(Page page, BooleanVector mask) {
        if (!mask.allFalse()) {
            if (mask.allTrue()) {
                this.addRawInputNotMasked(page);
            } else {
                this.addRawInputMasked(page, mask);
            }
        }
    }

    private void addRawInputMasked(Page page, BooleanVector mask) {
        DoubleBlock vBlock = (DoubleBlock)page.getBlock(this.channels.get(0));
        DoubleBlock outputValueBlock = (DoubleBlock)page.getBlock(this.channels.get(1));
        DoubleVector vVector = vBlock.asVector();
        if (vVector == null) {
            this.addRawBlock(vBlock, outputValueBlock, mask);
            return;
        }
        DoubleVector outputValueVector = outputValueBlock.asVector();
        if (outputValueVector == null) {
            this.addRawBlock(vBlock, outputValueBlock, mask);
            return;
        }
        this.addRawVector(vVector, outputValueVector, mask);
    }

    private void addRawInputNotMasked(Page page) {
        DoubleBlock vBlock = (DoubleBlock)page.getBlock(this.channels.get(0));
        DoubleBlock outputValueBlock = (DoubleBlock)page.getBlock(this.channels.get(1));
        DoubleVector vVector = vBlock.asVector();
        if (vVector == null) {
            this.addRawBlock(vBlock, outputValueBlock);
            return;
        }
        DoubleVector outputValueVector = outputValueBlock.asVector();
        if (outputValueVector == null) {
            this.addRawBlock(vBlock, outputValueBlock);
            return;
        }
        this.addRawVector(vVector, outputValueVector);
    }

    private void addRawVector(DoubleVector vVector, DoubleVector outputValueVector) {
        for (int valuesPosition = 0; valuesPosition < vVector.getPositionCount(); ++valuesPosition) {
            double vValue = vVector.getDouble(valuesPosition);
            double outputValueValue = outputValueVector.getDouble(valuesPosition);
            TopDoubleDoubleAggregator.combine(this.state, vValue, outputValueValue);
        }
    }

    private void addRawVector(DoubleVector vVector, DoubleVector outputValueVector, BooleanVector mask) {
        for (int valuesPosition = 0; valuesPosition < vVector.getPositionCount(); ++valuesPosition) {
            if (!mask.getBoolean(valuesPosition)) continue;
            double vValue = vVector.getDouble(valuesPosition);
            double outputValueValue = outputValueVector.getDouble(valuesPosition);
            TopDoubleDoubleAggregator.combine(this.state, vValue, outputValueValue);
        }
    }

    private void addRawBlock(DoubleBlock vBlock, DoubleBlock outputValueBlock) {
        for (int p = 0; p < vBlock.getPositionCount(); ++p) {
            int outputValueValueCount;
            int vValueCount = vBlock.getValueCount(p);
            if (vValueCount == 0 || (outputValueValueCount = outputValueBlock.getValueCount(p)) == 0) continue;
            int vStart = vBlock.getFirstValueIndex(p);
            int vEnd = vStart + vValueCount;
            for (int vOffset = vStart; vOffset < vEnd; ++vOffset) {
                double vValue = vBlock.getDouble(vOffset);
                int outputValueStart = outputValueBlock.getFirstValueIndex(p);
                int outputValueEnd = outputValueStart + outputValueValueCount;
                for (int outputValueOffset = outputValueStart; outputValueOffset < outputValueEnd; ++outputValueOffset) {
                    double outputValueValue = outputValueBlock.getDouble(outputValueOffset);
                    TopDoubleDoubleAggregator.combine(this.state, vValue, outputValueValue);
                }
            }
        }
    }

    private void addRawBlock(DoubleBlock vBlock, DoubleBlock outputValueBlock, BooleanVector mask) {
        for (int p = 0; p < vBlock.getPositionCount(); ++p) {
            int outputValueValueCount;
            int vValueCount;
            if (!mask.getBoolean(p) || (vValueCount = vBlock.getValueCount(p)) == 0 || (outputValueValueCount = outputValueBlock.getValueCount(p)) == 0) continue;
            int vStart = vBlock.getFirstValueIndex(p);
            int vEnd = vStart + vValueCount;
            for (int vOffset = vStart; vOffset < vEnd; ++vOffset) {
                double vValue = vBlock.getDouble(vOffset);
                int outputValueStart = outputValueBlock.getFirstValueIndex(p);
                int outputValueEnd = outputValueStart + outputValueValueCount;
                for (int outputValueOffset = outputValueStart; outputValueOffset < outputValueEnd; ++outputValueOffset) {
                    double outputValueValue = outputValueBlock.getDouble(outputValueOffset);
                    TopDoubleDoubleAggregator.combine(this.state, vValue, outputValueValue);
                }
            }
        }
    }

    @Override
    public void addIntermediateInput(Page page) {
        assert (this.channels.size() == this.intermediateBlockCount());
        assert (page.getBlockCount() >= this.channels.get(0) + TopDoubleDoubleAggregatorFunction.intermediateStateDesc().size());
        Object topUncast = page.getBlock(this.channels.get(0));
        if (topUncast.areAllValuesNull()) {
            return;
        }
        DoubleBlock top = (DoubleBlock)topUncast;
        assert (top.getPositionCount() == 1);
        Object outputUncast = page.getBlock(this.channels.get(1));
        if (outputUncast.areAllValuesNull()) {
            return;
        }
        DoubleBlock output = (DoubleBlock)outputUncast;
        assert (output.getPositionCount() == 1);
        TopDoubleDoubleAggregator.combineIntermediate(this.state, top, output);
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
        this.state.toIntermediate(blocks, offset, driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, DriverContext driverContext) {
        blocks[offset] = TopDoubleDoubleAggregator.evaluateFinal(this.state, driverContext);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

