/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.NodeUtils;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.EsField;
import org.elasticsearch.xpack.esql.index.EsIndex;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.plan.logical.LeafPlan;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;

public class EsRelation
extends LeafPlan {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(LogicalPlan.class, "EsRelation", EsRelation::readFrom);
    private final String indexPattern;
    private final IndexMode indexMode;
    private final Map<String, IndexMode> indexNameWithModes;
    private final List<Attribute> attrs;

    public EsRelation(Source source, EsIndex index, IndexMode indexMode) {
        this(source, index.name(), indexMode, index.indexNameWithModes(), EsRelation.flatten(source, index.mapping()));
    }

    public EsRelation(Source source, String indexPattern, IndexMode indexMode, Map<String, IndexMode> indexNameWithModes, List<Attribute> attributes) {
        super(source);
        this.indexPattern = indexPattern;
        this.indexMode = indexMode;
        this.indexNameWithModes = indexNameWithModes;
        this.attrs = attributes;
    }

    private static EsRelation readFrom(StreamInput in) throws IOException {
        Map<String, IndexMode> indexNameWithModes;
        String indexPattern;
        Source source = Source.readFrom((StreamInput)((PlanStreamInput)in));
        if (in.getTransportVersion().supports(TransportVersions.V_8_18_0)) {
            indexPattern = in.readString();
            indexNameWithModes = in.readMap(IndexMode::readFrom);
        } else {
            EsIndex index = EsIndex.readFrom(in);
            indexPattern = index.name();
            indexNameWithModes = index.indexNameWithModes();
        }
        List attributes = in.readNamedWriteableCollectionAsList(Attribute.class);
        IndexMode indexMode = IndexMode.fromString((String)in.readString());
        if (!in.getTransportVersion().supports(TransportVersions.V_8_18_0)) {
            in.readBoolean();
        }
        return new EsRelation(source, indexPattern, indexMode, indexNameWithModes, attributes);
    }

    public void writeTo(StreamOutput out) throws IOException {
        Source.EMPTY.writeTo(out);
        if (out.getTransportVersion().supports(TransportVersions.V_8_18_0)) {
            out.writeString(this.indexPattern);
            out.writeMap(this.indexNameWithModes, (o, v) -> IndexMode.writeTo((IndexMode)v, (StreamOutput)out));
        } else {
            new EsIndex(this.indexPattern, Map.of(), this.indexNameWithModes).writeTo(out);
        }
        out.writeNamedWriteableCollection(this.attrs);
        out.writeString(this.indexMode.getName());
        if (!out.getTransportVersion().supports(TransportVersions.V_8_18_0)) {
            out.writeBoolean(false);
        }
    }

    public String getWriteableName() {
        return EsRelation.ENTRY.name;
    }

    protected NodeInfo<EsRelation> info() {
        return NodeInfo.create((Node)this, EsRelation::new, (Object)this.indexPattern, (Object)this.indexMode, this.indexNameWithModes, this.attrs);
    }

    private static List<Attribute> flatten(Source source, Map<String, EsField> mapping) {
        return EsRelation.flatten(source, mapping, null);
    }

    private static List<Attribute> flatten(Source source, Map<String, EsField> mapping, FieldAttribute parent) {
        ArrayList<Attribute> list = new ArrayList<Attribute>();
        for (Map.Entry<String, EsField> entry : mapping.entrySet()) {
            String name = entry.getKey();
            EsField t = entry.getValue();
            if (t == null) continue;
            FieldAttribute f = new FieldAttribute(source, parent != null ? parent.name() : null, null, (String)(parent != null ? parent.name() + "." + name : name), t);
            list.add((Attribute)f);
            if (t.getProperties().isEmpty()) continue;
            list.addAll(EsRelation.flatten(source, t.getProperties(), f));
        }
        return list;
    }

    public String indexPattern() {
        return this.indexPattern;
    }

    public IndexMode indexMode() {
        return this.indexMode;
    }

    public Map<String, IndexMode> indexNameWithModes() {
        return this.indexNameWithModes;
    }

    @Override
    public List<Attribute> output() {
        return this.attrs;
    }

    public Set<String> concreteIndices() {
        return this.indexNameWithModes.keySet();
    }

    @Override
    public boolean expressionsResolved() {
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.indexPattern, this.indexMode, this.indexNameWithModes, this.attrs);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        EsRelation other = (EsRelation)((Object)obj);
        return Objects.equals(this.indexPattern, other.indexPattern) && Objects.equals(this.indexMode, other.indexMode) && Objects.equals(this.indexNameWithModes, other.indexNameWithModes) && Objects.equals(this.attrs, other.attrs);
    }

    public String nodeString() {
        return this.nodeName() + "[" + this.indexPattern + "]" + (String)(this.indexMode != IndexMode.STANDARD ? "[" + this.indexMode.name() + "]" : "") + NodeUtils.limitedToString(this.attrs);
    }

    public EsRelation withAttributes(List<Attribute> newAttributes) {
        return new EsRelation(this.source(), this.indexPattern, this.indexMode, this.indexNameWithModes, newAttributes);
    }

    public EsRelation withIndexMode(IndexMode indexMode) {
        return new EsRelation(this.source(), this.indexPattern, indexMode, this.indexNameWithModes, this.attrs);
    }
}

