/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference.chunking;

import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.ChunkingSettings;
import org.elasticsearch.inference.ChunkingStrategy;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.inference.InferenceUtils;
import org.elasticsearch.xpack.core.inference.chunking.ChunkingSettingsOptions;

public class SentenceBoundaryChunkingSettings
implements ChunkingSettings {
    public static final String NAME = "SentenceBoundaryChunkingSettings";
    private static final ChunkingStrategy STRATEGY = ChunkingStrategy.SENTENCE;
    private static final int MAX_CHUNK_SIZE_LOWER_LIMIT = 20;
    private static final Set<String> VALID_KEYS = Set.of(ChunkingSettingsOptions.STRATEGY.toString(), ChunkingSettingsOptions.MAX_CHUNK_SIZE.toString(), ChunkingSettingsOptions.SENTENCE_OVERLAP.toString());
    private static int DEFAULT_OVERLAP = 1;
    protected final int maxChunkSize;
    protected int sentenceOverlap = DEFAULT_OVERLAP;

    public SentenceBoundaryChunkingSettings(Integer maxChunkSize, @Nullable Integer sentenceOverlap) {
        this.maxChunkSize = maxChunkSize;
        this.sentenceOverlap = sentenceOverlap == null ? DEFAULT_OVERLAP : sentenceOverlap;
    }

    public SentenceBoundaryChunkingSettings(StreamInput in) throws IOException {
        this.maxChunkSize = in.readInt();
        this.sentenceOverlap = in.readVInt();
    }

    public Integer maxChunkSize() {
        return this.maxChunkSize;
    }

    public int sentenceOverlap() {
        return this.sentenceOverlap;
    }

    public void validate() {
        ValidationException validationException = new ValidationException();
        if (this.maxChunkSize < 20) {
            validationException.addValidationError(String.valueOf((Object)ChunkingSettingsOptions.MAX_CHUNK_SIZE) + "[" + this.maxChunkSize + "] must be above 20");
        }
        if (this.sentenceOverlap > 1 || this.sentenceOverlap < 0) {
            validationException.addValidationError(String.valueOf((Object)ChunkingSettingsOptions.SENTENCE_OVERLAP) + "[" + this.sentenceOverlap + "] must be either 0 or 1");
        }
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
    }

    public Map<String, Object> asMap() {
        return Map.of(ChunkingSettingsOptions.STRATEGY.toString(), STRATEGY.toString().toLowerCase(Locale.ROOT), ChunkingSettingsOptions.MAX_CHUNK_SIZE.toString(), this.maxChunkSize, ChunkingSettingsOptions.SENTENCE_OVERLAP.toString(), this.sentenceOverlap);
    }

    public static SentenceBoundaryChunkingSettings fromMap(Map<String, Object> map) {
        ValidationException validationException = new ValidationException();
        Object[] invalidSettings = map.keySet().stream().filter(key -> !VALID_KEYS.contains(key)).toArray();
        if (invalidSettings.length > 0) {
            validationException.addValidationError(Strings.format((String)"Sentence based chunking settings can not have the following settings: %s", (Object[])new Object[]{Arrays.toString(invalidSettings)}));
        }
        Integer maxChunkSize = InferenceUtils.extractRequiredPositiveIntegerGreaterThanOrEqualToMin(map, ChunkingSettingsOptions.MAX_CHUNK_SIZE.toString(), 20, "chunking_settings", validationException);
        Integer sentenceOverlap = InferenceUtils.removeAsType(map, ChunkingSettingsOptions.SENTENCE_OVERLAP.toString(), Integer.class, validationException);
        if (sentenceOverlap == null) {
            sentenceOverlap = DEFAULT_OVERLAP;
        } else if (sentenceOverlap > 1 || sentenceOverlap < 0) {
            validationException.addValidationError(String.valueOf((Object)ChunkingSettingsOptions.SENTENCE_OVERLAP) + "[" + sentenceOverlap + "] must be either 0 or 1");
        }
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new SentenceBoundaryChunkingSettings(maxChunkSize, sentenceOverlap);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ChunkingSettingsOptions.STRATEGY.toString(), (Enum)STRATEGY);
        builder.field(ChunkingSettingsOptions.MAX_CHUNK_SIZE.toString(), this.maxChunkSize);
        builder.field(ChunkingSettingsOptions.SENTENCE_OVERLAP.toString(), this.sentenceOverlap);
        builder.endObject();
        return builder;
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_16_0;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeInt(this.maxChunkSize);
        out.writeVInt(this.sentenceOverlap);
    }

    public ChunkingStrategy getChunkingStrategy() {
        return STRATEGY;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SentenceBoundaryChunkingSettings that = (SentenceBoundaryChunkingSettings)o;
        return Objects.equals(this.maxChunkSize, that.maxChunkSize) && Objects.equals(this.sentenceOverlap, that.sentenceOverlap);
    }

    public int hashCode() {
        return Objects.hash(this.maxChunkSize, this.sentenceOverlap);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }
}

