/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.template.put;

import java.util.Optional;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.template.put.PutComponentTemplateAction;
import org.elasticsearch.action.admin.indices.template.reservedstate.ReservedComposableIndexTemplateAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.ComponentTemplate;
import org.elasticsearch.cluster.metadata.MetadataIndexTemplateService;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.project.ProjectStateRegistry;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportPutComponentTemplateAction
extends AcknowledgedTransportMasterNodeAction<PutComponentTemplateAction.Request> {
    private final MetadataIndexTemplateService indexTemplateService;
    private final ProjectResolver projectResolver;

    @Inject
    public TransportPutComponentTemplateAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataIndexTemplateService indexTemplateService, ActionFilters actionFilters, ProjectResolver projectResolver) {
        super("cluster:admin/component_template/put", transportService, clusterService, threadPool, actionFilters, PutComponentTemplateAction.Request::new, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.indexTemplateService = indexTemplateService;
        this.projectResolver = projectResolver;
    }

    @Override
    protected ClusterBlockException checkBlock(PutComponentTemplateAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(this.projectResolver.getProjectId(), ClusterBlockLevel.METADATA_WRITE);
    }

    @Override
    protected void masterOperation(Task task, PutComponentTemplateAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) throws Exception {
        ProjectMetadata project = this.projectResolver.getProjectMetadata(state);
        ComponentTemplate componentTemplate = this.indexTemplateService.normalizeComponentTemplate(request.componentTemplate());
        ComponentTemplate existingTemplate = project.componentTemplates().get(request.name());
        if (existingTemplate != null) {
            if (request.create()) {
                listener.onFailure(new IllegalArgumentException("component template [" + request.name() + "] already exists"));
                return;
            }
            if (componentTemplate.contentEquals(existingTemplate)) {
                listener.onResponse(AcknowledgedResponse.TRUE);
                return;
            }
        }
        this.indexTemplateService.putComponentTemplate(request.cause(), request.create(), request.name(), request.masterNodeTimeout(), componentTemplate, project.id(), listener);
    }

    @Override
    public Optional<String> reservedStateHandlerName() {
        return Optional.of("index_templates");
    }

    @Override
    public Set<String> modifiedKeys(PutComponentTemplateAction.Request request) {
        return Set.of(ReservedComposableIndexTemplateAction.reservedComponentName(request.name()));
    }

    @Override
    protected void validateForReservedState(PutComponentTemplateAction.Request request, ClusterState state) {
        super.validateForReservedState(request, state);
        this.validateForReservedState(ProjectStateRegistry.get(state).reservedStateMetadata(this.projectResolver.getProjectId()).values(), this.reservedStateHandlerName().get(), this.modifiedKeys(request), request::toString);
    }
}

