/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.create;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotRequest;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotsService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportCreateSnapshotAction
extends TransportMasterNodeAction<CreateSnapshotRequest, CreateSnapshotResponse> {
    public static final ActionType<CreateSnapshotResponse> TYPE = new ActionType("cluster:admin/snapshot/create");
    private final SnapshotsService snapshotsService;
    private final ProjectResolver projectResolver;

    @Inject
    public TransportCreateSnapshotAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, SnapshotsService snapshotsService, ActionFilters actionFilters, ProjectResolver projectResolver) {
        super(TYPE.name(), transportService, clusterService, threadPool, actionFilters, CreateSnapshotRequest::new, CreateSnapshotResponse::new, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.snapshotsService = snapshotsService;
        this.projectResolver = projectResolver;
    }

    @Override
    protected ClusterBlockException checkBlock(CreateSnapshotRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(this.projectResolver.getProjectId(), ClusterBlockLevel.METADATA_READ);
    }

    @Override
    protected void masterOperation(Task task, CreateSnapshotRequest request, ClusterState state, ActionListener<CreateSnapshotResponse> listener) {
        if (request.waitForCompletion()) {
            this.snapshotsService.executeSnapshot(this.projectResolver.getProjectId(), request, listener.map(CreateSnapshotResponse::new));
        } else {
            this.snapshotsService.createSnapshot(this.projectResolver.getProjectId(), request, listener.map(snapshot -> new CreateSnapshotResponse((SnapshotInfo)null)));
        }
    }
}

