/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.downsample;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.flattened.FlattenedFieldMapper;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.xpack.downsample.AbstractDownsampleFieldProducer;
import org.elasticsearch.xpack.downsample.DimensionFieldProducer;
import org.elasticsearch.xpack.downsample.FieldValueFetcher;

public class DimensionFieldValueFetcher
extends FieldValueFetcher {
    private final DimensionFieldProducer dimensionFieldProducer = this.createFieldProducer();

    protected DimensionFieldValueFetcher(String fieldName, MappedFieldType fieldType, IndexFieldData<?> fieldData) {
        super(fieldName, fieldType, fieldData, null);
    }

    private DimensionFieldProducer createFieldProducer() {
        return new DimensionFieldProducer(this.name, new DimensionFieldProducer.Dimension(this.name));
    }

    @Override
    public AbstractDownsampleFieldProducer fieldProducer() {
        return this.dimensionFieldProducer;
    }

    static List<FieldValueFetcher> create(SearchExecutionContext context, String[] dimensions) {
        ArrayList<DimensionFieldValueFetcher> fetchers = new ArrayList<DimensionFieldValueFetcher>();
        for (String dimension : dimensions) {
            MappedFieldType fieldType = context.getFieldType(dimension);
            assert (fieldType != null) : "Unknown type for dimension field: [" + dimension + "]";
            if (!context.fieldExistsInIndex(fieldType.name())) continue;
            IndexFieldData fieldData = context.getForField(fieldType, MappedFieldType.FielddataOperation.SEARCH);
            if (fieldType instanceof FlattenedFieldMapper.KeyedFlattenedFieldType) {
                FlattenedFieldMapper.KeyedFlattenedFieldType flattenedFieldType = (FlattenedFieldMapper.KeyedFlattenedFieldType)fieldType;
                String dimensionName = flattenedFieldType.rootName() + "." + flattenedFieldType.key();
                fetchers.add(new DimensionFieldValueFetcher(dimensionName, fieldType, fieldData));
                continue;
            }
            String fieldName = context.isMultiField(dimension) ? fieldType.name().substring(0, fieldType.name().lastIndexOf(46)) : fieldType.name();
            fetchers.add(new DimensionFieldValueFetcher(fieldName, fieldType, fieldData));
        }
        return Collections.unmodifiableList(fetchers);
    }
}

