/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicy;
import org.elasticsearch.xpack.core.ml.MlStatsIndex;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.notifications.NotificationsIndex;
import org.elasticsearch.xpack.core.template.IndexTemplateConfig;
import org.elasticsearch.xpack.core.template.IndexTemplateRegistry;
import org.elasticsearch.xpack.core.template.LifecyclePolicyConfig;

public class MlIndexTemplateRegistry
extends IndexTemplateRegistry {
    public static final int ML_INDEX_TEMPLATE_VERSION = 10000005;
    private static final String ROOT_RESOURCE_PATH = "/ml/";
    private static final String ANOMALY_DETECTION_PATH = "/ml/anomalydetection/";
    private static final String VERSION_PATTERN = "xpack.ml.version";
    private static final String VERSION_ID_PATTERN = "xpack.ml.version.id";
    private static final String INDEX_LIFECYCLE_NAME = "xpack.ml.index.lifecycle.name";
    private static final String INDEX_LIFECYCLE_ROLLOVER_ALIAS = "xpack.ml.index.lifecycle.rollover_alias";
    public static final IndexTemplateConfig NOTIFICATIONS_TEMPLATE = MlIndexTemplateRegistry.notificationsTemplate();
    private static final String ML_SIZE_BASED_ILM_POLICY_NAME = "ml-size-based-ilm-policy";
    private final boolean useIlm;
    private final Map<String, ComposableIndexTemplate> composableIndexTemplateConfigs;
    private static final LifecyclePolicyConfig LIFECYCLE_POLICY_CONFIG = new LifecyclePolicyConfig("ml-size-based-ilm-policy", "/ml/size_based_ilm_policy.json");

    private IndexTemplateConfig stateTemplate() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put(VERSION_ID_PATTERN, String.valueOf(10000005));
        return new IndexTemplateConfig(".ml-state", "/ml/anomalydetection/state_index_template.json", 10000005, VERSION_PATTERN, variables);
    }

    private static IndexTemplateConfig anomalyDetectionResultsTemplate() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put(VERSION_ID_PATTERN, String.valueOf(10000005));
        variables.put("xpack.ml.anomalydetection.results.mappings", AnomalyDetectorsIndex.resultsMapping());
        return new IndexTemplateConfig(AnomalyDetectorsIndex.jobResultsIndexPrefix(), "/ml/anomalydetection/results_index_template.json", 10000005, VERSION_PATTERN, variables);
    }

    private static IndexTemplateConfig notificationsTemplate() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put(VERSION_ID_PATTERN, String.valueOf(10000005));
        variables.put("xpack.ml.notifications.mappings", NotificationsIndex.mapping());
        return new IndexTemplateConfig(".ml-notifications-000002", "/ml/notifications_index_template.json", 10000005, VERSION_PATTERN, variables);
    }

    private IndexTemplateConfig statsTemplate() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put(VERSION_ID_PATTERN, String.valueOf(10000005));
        variables.put("xpack.ml.stats.mappings", MlStatsIndex.mapping());
        variables.put(INDEX_LIFECYCLE_NAME, ML_SIZE_BASED_ILM_POLICY_NAME);
        variables.put(INDEX_LIFECYCLE_ROLLOVER_ALIAS, MlStatsIndex.writeAlias());
        return new IndexTemplateConfig(".ml-stats", "/ml/stats_index_template.json", 10000005, VERSION_PATTERN, variables);
    }

    public MlIndexTemplateRegistry(Settings nodeSettings, ClusterService clusterService, ThreadPool threadPool, Client client, boolean useIlm, NamedXContentRegistry xContentRegistry) {
        super(nodeSettings, clusterService, threadPool, client, xContentRegistry);
        this.useIlm = useIlm;
        this.composableIndexTemplateConfigs = MlIndexTemplateRegistry.parseComposableTemplates((IndexTemplateConfig[])new IndexTemplateConfig[]{MlIndexTemplateRegistry.anomalyDetectionResultsTemplate(), this.stateTemplate(), NOTIFICATIONS_TEMPLATE, this.statsTemplate()});
    }

    protected boolean requiresMasterNode() {
        return true;
    }

    protected Map<String, ComposableIndexTemplate> getComposableTemplateConfigs() {
        return this.composableIndexTemplateConfigs;
    }

    protected List<LifecyclePolicyConfig> getLifecycleConfigs() {
        return List.of(LIFECYCLE_POLICY_CONFIG);
    }

    protected List<LifecyclePolicy> getLifecyclePolicies() {
        if (!this.useIlm) {
            return List.of();
        }
        return this.lifecyclePolicies;
    }

    protected String getOrigin() {
        return "ml";
    }
}

