/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.gpu;

import com.nvidia.cuvs.CuVSResources;
import com.nvidia.cuvs.GPUInfo;
import com.nvidia.cuvs.GPUInfoProvider;
import com.nvidia.cuvs.spi.CuVSProvider;
import java.util.List;
import org.elasticsearch.common.Strings;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;

public class GPUSupport {
    private static final Logger LOG = LogManager.getLogger(GPUSupport.class);
    private static final long MIN_DEVICE_MEMORY_IN_BYTES = 0x1E0000000L;

    private static long initializeGpuInfo() {
        try {
            GPUInfoProvider gpuInfoProvider = CuVSProvider.provider().gpuInfoProvider();
            List availableGPUs = gpuInfoProvider.availableGPUs();
            if (availableGPUs.isEmpty()) {
                LOG.warn("No GPU found");
                return -1L;
            }
            for (GPUInfo gpu : availableGPUs) {
                boolean hasRequiredMemory;
                int major = gpu.computeCapabilityMajor();
                int minor = gpu.computeCapabilityMinor();
                boolean hasRequiredCapability = major >= 7 && (major > 7 || minor >= 0);
                boolean bl = hasRequiredMemory = gpu.totalDeviceMemoryInBytes() >= 0x1E0000000L;
                if (!hasRequiredCapability) {
                    LOG.warn("GPU [{}] does not have the minimum compute capabilities (required: [{}.{}], found: [{}.{}])", new Object[]{gpu.name(), 7, 0, gpu.computeCapabilityMajor(), gpu.computeCapabilityMinor()});
                    continue;
                }
                if (!hasRequiredMemory) {
                    LOG.warn("GPU [{}] does not have minimum memory required (required: [{}], found: [{}])", new Object[]{gpu.name(), 0x1E0000000L, gpu.totalDeviceMemoryInBytes()});
                    continue;
                }
                LOG.info("Found compatible GPU [{}] (id: [{}])", new Object[]{gpu.name(), gpu.gpuId()});
                return gpu.totalDeviceMemoryInBytes();
            }
            return -1L;
        }
        catch (UnsupportedOperationException uoe) {
            String msg = uoe.getMessage() == null ? Strings.format((String)"runtime Java version [%d], OS [%s], arch [%s]", (Object[])new Object[]{Runtime.version().feature(), System.getProperty("os.name"), System.getProperty("os.arch")}) : uoe.getMessage();
            LOG.warn("GPU based vector indexing is not supported on this platform; " + msg);
            return -1L;
        }
        catch (Throwable t) {
            if (t instanceof ExceptionInInitializerError) {
                ExceptionInInitializerError ex = (ExceptionInInitializerError)t;
                t = ex.getCause();
            }
            LOG.warn("Exception occurred during creation of cuvs resources", t);
            return -1L;
        }
    }

    public static boolean isSupported() {
        return Holder.IS_SUPPORTED;
    }

    public static CuVSResources cuVSResourcesOrNull(boolean logError) {
        block5: {
            try {
                CuVSResources resources = CuVSResources.create();
                return resources;
            }
            catch (UnsupportedOperationException uoe) {
                if (logError) {
                    Object msg = "";
                    msg = uoe.getMessage() == null ? "Runtime Java version: " + Runtime.version().feature() : ": " + uoe.getMessage();
                    LOG.warn("GPU based vector indexing is not supported on this platform or java version; " + (String)msg);
                }
            }
            catch (Throwable t) {
                if (!logError) break block5;
                if (t instanceof ExceptionInInitializerError) {
                    ExceptionInInitializerError ex = (ExceptionInInitializerError)t;
                    t = ex.getCause();
                }
                LOG.warn("Exception occurred during creation of cuvs resources", t);
            }
        }
        return null;
    }

    public static long getTotalGpuMemory() {
        return Holder.TOTAL_GPU_MEMORY;
    }

    private static class Holder {
        static final long TOTAL_GPU_MEMORY = GPUSupport.initializeGpuInfo();
        static final boolean IS_SUPPORTED = TOTAL_GPU_MEMORY != -1L;

        private Holder() {
        }
    }
}

