/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.session;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesFailure;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.compute.operator.DriverCompletionInfo;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.indices.IndicesExpressionGrouper;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.NoSuchRemoteClusterException;
import org.elasticsearch.transport.RemoteClusterAware;
import org.elasticsearch.transport.RemoteTransportException;
import org.elasticsearch.xpack.esql.VerificationException;
import org.elasticsearch.xpack.esql.action.EsqlExecutionInfo;
import org.elasticsearch.xpack.esql.analysis.Analyzer;
import org.elasticsearch.xpack.esql.index.IndexResolution;
import org.elasticsearch.xpack.esql.plan.IndexPattern;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.session.EsqlLicenseChecker;
import org.elasticsearch.xpack.esql.session.NoClustersToSearchException;
import org.elasticsearch.xpack.esql.session.Result;
import org.elasticsearch.xpack.esql.session.Versioned;

public class EsqlCCSUtils {
    private EsqlCCSUtils() {
    }

    static Map<String, List<FieldCapabilitiesFailure>> groupFailuresPerCluster(List<FieldCapabilitiesFailure> failures) {
        HashMap<String, List<FieldCapabilitiesFailure>> perCluster = new HashMap<String, List<FieldCapabilitiesFailure>>();
        for (FieldCapabilitiesFailure failure : failures) {
            String cluster = RemoteClusterAware.parseClusterAlias((String)failure.getIndices()[0]);
            perCluster.computeIfAbsent(cluster, k -> new ArrayList()).add(failure);
        }
        return perCluster;
    }

    static Map<String, FieldCapabilitiesFailure> determineUnavailableRemoteClusters(Map<String, List<FieldCapabilitiesFailure>> failures) {
        HashMap<String, FieldCapabilitiesFailure> unavailableRemotes = new HashMap<String, FieldCapabilitiesFailure>(failures.size());
        for (Map.Entry<String, List<FieldCapabilitiesFailure>> e : failures.entrySet()) {
            if ("".equals(e.getKey()) || !e.getValue().stream().allMatch(f -> ExceptionsHelper.isRemoteUnavailableException((Exception)f.getException()))) continue;
            unavailableRemotes.put(e.getKey(), e.getValue().get(0));
        }
        return unavailableRemotes;
    }

    static boolean returnSuccessWithEmptyResult(EsqlExecutionInfo executionInfo, Exception e) {
        if (!executionInfo.isCrossClusterSearch()) {
            return false;
        }
        if (e instanceof NoClustersToSearchException || ExceptionsHelper.isRemoteUnavailableException((Exception)e)) {
            for (String clusterAlias : executionInfo.clusterAliases()) {
                if (clusterAlias.equals("") || executionInfo.shouldSkipOnFailure(clusterAlias)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    static void updateExecutionInfoToReturnEmptyResult(EsqlExecutionInfo executionInfo, Exception e) {
        executionInfo.markEndQuery();
        Exception exceptionForResponse = e instanceof ConnectTransportException ? new RemoteTransportException("connect_transport_exception - unable to connect to remote cluster", null) : e;
        for (String clusterAlias : executionInfo.clusterAliases()) {
            executionInfo.swapCluster(clusterAlias, (k, v) -> {
                EsqlExecutionInfo.Cluster.Builder builder = new EsqlExecutionInfo.Cluster.Builder((EsqlExecutionInfo.Cluster)v).setTook(executionInfo.overallTook()).setTotalShards(0).setSuccessfulShards(0).setSkippedShards(0).setFailedShards(0);
                if ("".equals(clusterAlias)) {
                    builder.setStatus(EsqlExecutionInfo.Cluster.Status.SUCCESSFUL);
                } else {
                    builder.setStatus(EsqlExecutionInfo.Cluster.Status.SKIPPED);
                    if (v.getFailures().isEmpty()) {
                        builder.addFailures(List.of(new ShardSearchFailure(exceptionForResponse)));
                    }
                }
                return builder.build();
            });
        }
    }

    static String createQualifiedLookupIndexExpressionFromAvailableClusters(EsqlExecutionInfo executionInfo, String localPattern) {
        if (executionInfo.getClusters().isEmpty()) {
            return localPattern;
        }
        return executionInfo.getRunningClusterAliases().map(clusterAlias -> RemoteClusterAware.buildRemoteIndexName((String)clusterAlias, (String)localPattern)).collect(Collectors.joining(","));
    }

    static void updateExecutionInfoWithUnavailableClusters(EsqlExecutionInfo execInfo, Map<String, List<FieldCapabilitiesFailure>> failures) {
        Map<String, FieldCapabilitiesFailure> unavailable = EsqlCCSUtils.determineUnavailableRemoteClusters(failures);
        for (Map.Entry<String, FieldCapabilitiesFailure> entry : unavailable.entrySet()) {
            String clusterAlias = entry.getKey();
            boolean skipUnavailable = execInfo.getCluster(clusterAlias).isSkipUnavailable();
            RemoteTransportException e = new RemoteTransportException(Strings.format((String)"Remote cluster [%s] (with setting skip_unavailable=%s) is not available", (Object[])new Object[]{clusterAlias, skipUnavailable}), (Throwable)entry.getValue().getException());
            if (skipUnavailable) {
                EsqlCCSUtils.markClusterWithFinalStateAndNoShards(execInfo, clusterAlias, EsqlExecutionInfo.Cluster.Status.SKIPPED, (Exception)e);
                continue;
            }
            throw e;
        }
    }

    static void updateExecutionInfoWithClustersWithNoMatchingIndices(EsqlExecutionInfo executionInfo, Collection<IndexResolution> indexResolutions, boolean usedFilter) {
        if (executionInfo.clusterInfo.isEmpty()) {
            return;
        }
        Set clustersWithNoMatchingIndices = executionInfo.getRunningClusterAliases().collect(Collectors.toSet());
        for (IndexResolution indexResolution : indexResolutions) {
            for (String indexName : indexResolution.resolvedIndices()) {
                clustersWithNoMatchingIndices.remove(RemoteClusterAware.parseClusterAlias((String)indexName));
            }
        }
        Object fatalErrorMessage = null;
        for (String c : clustersWithNoMatchingIndices) {
            String indexExpression = executionInfo.getCluster(c).getIndexExpression();
            if (EsqlCCSUtils.concreteIndexRequested(executionInfo.getCluster(c).getIndexExpression())) {
                String error = Strings.format((String)"Unknown index [%s]", (Object[])new Object[]{c.equals("") ? indexExpression : c + ":" + indexExpression});
                if (!executionInfo.shouldSkipOnFailure(c) || usedFilter) {
                    fatalErrorMessage = fatalErrorMessage == null ? error : (String)fatalErrorMessage + "; " + error;
                }
                if (usedFilter) continue;
                EsqlCCSUtils.markClusterWithFinalStateAndNoShards(executionInfo, c, executionInfo.shouldSkipOnFailure(c) ? EsqlExecutionInfo.Cluster.Status.SKIPPED : EsqlExecutionInfo.Cluster.Status.FAILED, (Exception)((Object)new VerificationException(error, new Object[0])));
                continue;
            }
            for (IndexResolution indexResolution : indexResolutions) {
                if (!indexResolution.isValid()) continue;
                List failures = indexResolution.failures().getOrDefault(c, List.of());
                if (failures.isEmpty()) {
                    EsqlCCSUtils.markClusterWithFinalStateAndNoShards(executionInfo, c, EsqlExecutionInfo.Cluster.Status.SUCCESSFUL, null);
                    continue;
                }
                Exception nonIndexNotFound = failures.stream().map(FieldCapabilitiesFailure::getException).filter(ex -> ExceptionsHelper.unwrap((Throwable)ex, (Class[])new Class[]{IndexNotFoundException.class}) == null).findAny().orElse(null);
                EsqlCCSUtils.markClusterWithFinalStateAndNoShards(executionInfo, c, EsqlExecutionInfo.Cluster.Status.SKIPPED, nonIndexNotFound);
            }
        }
        if (fatalErrorMessage != null) {
            throw new VerificationException((String)fatalErrorMessage, new Object[0]);
        }
    }

    static void updateExecutionInfoWithClustersWithNoMatchingIndices(EsqlExecutionInfo executionInfo, Set<IndexResolution> indexResolutions) {
        EsqlCCSUtils.updateExecutionInfoWithClustersWithNoMatchingIndices(executionInfo, indexResolutions, false);
    }

    static boolean concreteIndexRequested(String indexExpression) {
        if (Strings.isNullOrBlank((String)indexExpression)) {
            return false;
        }
        for (String expr : indexExpression.split(",")) {
            if (expr.charAt(0) == '<' || expr.startsWith("-<") || expr.indexOf(42) >= 0) continue;
            return true;
        }
        return false;
    }

    static void updateExecutionInfoAtEndOfPlanning(EsqlExecutionInfo execInfo) {
        execInfo.markEndPlanning();
        if (execInfo.isCrossClusterSearch() || execInfo.includeExecutionMetadata() == EsqlExecutionInfo.IncludeExecutionMetadata.ALWAYS) {
            for (String clusterAlias : execInfo.clusterAliases()) {
                EsqlExecutionInfo.Cluster cluster = execInfo.getCluster(clusterAlias);
                if (cluster.getStatus() != EsqlExecutionInfo.Cluster.Status.SKIPPED) continue;
                execInfo.swapCluster(clusterAlias, (k, v) -> new EsqlExecutionInfo.Cluster.Builder((EsqlExecutionInfo.Cluster)v).setTook(execInfo.planningTookTime()).setTotalShards(0).setSuccessfulShards(0).setSkippedShards(0).setFailedShards(0).build());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initCrossClusterState(IndicesExpressionGrouper indicesGrouper, XPackLicenseState licenseState, Set<IndexPattern> indexPatterns, EsqlExecutionInfo executionInfo) throws ElasticsearchStatusException {
        if (indexPatterns.isEmpty()) {
            return;
        }
        try {
            for (IndexPattern indexPattern : indexPatterns) {
                Map groupedIndices = indicesGrouper.groupIndices(IndicesOptions.DEFAULT, Strings.splitStringByCommaToArray((String)indexPattern.indexPattern()), false);
                executionInfo.clusterInfoInitializing(true);
                try {
                    groupedIndices.forEach((clusterAlias, indices) -> executionInfo.swapCluster((String)clusterAlias, (k, v) -> {
                        Object indexExpr = Strings.arrayToCommaDelimitedString((Object[])indices.indices());
                        if (v != null) {
                            indexExpr = v.getIndexExpression() + "," + (String)indexExpr;
                        }
                        return new EsqlExecutionInfo.Cluster((String)clusterAlias, (String)indexExpr, executionInfo.shouldSkipOnFailure((String)clusterAlias));
                    }));
                }
                finally {
                    executionInfo.clusterInfoInitializing(false);
                }
            }
            if (executionInfo.isCrossClusterSearch() && !EsqlLicenseChecker.isCcsAllowed(licenseState)) {
                throw EsqlLicenseChecker.invalidLicenseForCcsException(licenseState);
            }
        }
        catch (NoSuchRemoteClusterException e) {
            if (EsqlLicenseChecker.isCcsAllowed(licenseState)) {
                throw e;
            }
            throw EsqlLicenseChecker.invalidLicenseForCcsException(licenseState);
        }
    }

    public static void markClusterWithFinalStateAndNoShards(EsqlExecutionInfo executionInfo, String clusterAlias, EsqlExecutionInfo.Cluster.Status status, @Nullable Exception ex) {
        assert (status != EsqlExecutionInfo.Cluster.Status.RUNNING) : "status must be a final state, not RUNNING";
        executionInfo.swapCluster(clusterAlias, (k, v) -> {
            EsqlExecutionInfo.Cluster.Builder builder = new EsqlExecutionInfo.Cluster.Builder((EsqlExecutionInfo.Cluster)v).setStatus(status).setTook(executionInfo.tookSoFar()).setTotalShards(Objects.requireNonNullElse(v.getTotalShards(), 0)).setSuccessfulShards(Objects.requireNonNullElse(v.getSuccessfulShards(), 0)).setSkippedShards(Objects.requireNonNullElse(v.getSkippedShards(), 0)).setFailedShards(Objects.requireNonNullElse(v.getFailedShards(), 0));
            if (ex != null) {
                builder.addFailures(List.of(new ShardSearchFailure(ex)));
            }
            return builder.build();
        });
    }

    public static boolean canAllowPartial(Exception e) {
        Throwable unwrapped = ExceptionsHelper.unwrapCause((Throwable)e);
        return !(unwrapped instanceof IndexNotFoundException) && !(unwrapped instanceof ElasticsearchSecurityException);
    }

    public static String inClusterName(String clusterAlias) {
        if ("".equals(clusterAlias)) {
            return "in local cluster";
        }
        return "in remote cluster [" + clusterAlias + "]";
    }

    static abstract class CssPartialErrorsActionListener
    implements ActionListener<Versioned<LogicalPlan>> {
        private final EsqlExecutionInfo executionInfo;
        private final ActionListener<Result> listener;

        CssPartialErrorsActionListener(EsqlExecutionInfo executionInfo, ActionListener<Result> listener) {
            this.executionInfo = executionInfo;
            this.listener = listener;
        }

        public void onFailure(Exception e) {
            if (EsqlCCSUtils.returnSuccessWithEmptyResult(this.executionInfo, e)) {
                EsqlCCSUtils.updateExecutionInfoToReturnEmptyResult(this.executionInfo, e);
                this.listener.onResponse((Object)new Result(Analyzer.NO_FIELDS, Collections.emptyList(), DriverCompletionInfo.EMPTY, this.executionInfo));
            } else {
                this.listener.onFailure(e);
            }
        }
    }
}

