/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.analysis.common;

import java.util.regex.Pattern;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.pattern.PatternTokenizer;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenizerFactory;

public class PatternTokenizerFactory
extends AbstractTokenizerFactory {
    private final Pattern pattern;
    private final int group;

    PatternTokenizerFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(name);
        String sPattern = settings.get("pattern", "\\W+");
        if (sPattern == null) {
            throw new IllegalArgumentException("pattern is missing for [" + name + "] tokenizer of type 'pattern'");
        }
        this.pattern = Regex.compile((String)sPattern, (String)settings.get("flags"));
        this.group = settings.getAsInt("group", Integer.valueOf(-1));
    }

    public Tokenizer create() {
        return new PatternTokenizer(this.pattern, this.group);
    }
}

