/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.openshiftai.request.embeddings;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.inference.common.Truncator;
import org.elasticsearch.xpack.inference.external.request.HttpRequest;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.request.RequestUtils;
import org.elasticsearch.xpack.inference.services.openshiftai.embeddings.OpenShiftAiEmbeddingsModel;
import org.elasticsearch.xpack.inference.services.openshiftai.request.embeddings.OpenShiftAiEmbeddingsRequestEntity;

public class OpenShiftAiEmbeddingsRequest
implements Request {
    private final OpenShiftAiEmbeddingsModel model;
    private final Truncator.TruncationResult truncationResult;
    private final Truncator truncator;

    public OpenShiftAiEmbeddingsRequest(Truncator truncator, Truncator.TruncationResult input, OpenShiftAiEmbeddingsModel model) {
        this.model = model;
        this.truncator = truncator;
        this.truncationResult = input;
    }

    @Override
    public HttpRequest createHttpRequest() {
        HttpPost httpPost = new HttpPost(this.model.getServiceSettings().uri());
        ByteArrayEntity byteEntity = new ByteArrayEntity(Strings.toString((ToXContent)new OpenShiftAiEmbeddingsRequestEntity(this.truncationResult.input(), this.model.getServiceSettings().modelId(), this.model.getServiceSettings().dimensions(), this.model.getServiceSettings().dimensionsSetByUser())).getBytes(StandardCharsets.UTF_8));
        httpPost.setEntity((HttpEntity)byteEntity);
        httpPost.setHeader("Content-Type", XContentType.JSON.mediaTypeWithoutParameters());
        httpPost.setHeader(RequestUtils.createAuthBearerHeader(this.model.getSecretSettings().apiKey()));
        return new HttpRequest((HttpRequestBase)httpPost, this.getInferenceEntityId());
    }

    @Override
    public URI getURI() {
        return this.model.getServiceSettings().uri();
    }

    @Override
    public Request truncate() {
        Truncator.TruncationResult truncatedInput = this.truncator.truncate(this.truncationResult.input());
        return new OpenShiftAiEmbeddingsRequest(this.truncator, truncatedInput, this.model);
    }

    @Override
    public boolean[] getTruncationInfo() {
        return (boolean[])this.truncationResult.truncated().clone();
    }

    @Override
    public String getInferenceEntityId() {
        return this.model.getInferenceEntityId();
    }
}

