/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.llama.action;

import java.util.Objects;
import org.elasticsearch.core.Strings;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xpack.inference.common.Truncator;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.SenderExecutableAction;
import org.elasticsearch.xpack.inference.external.action.SingleInputSenderExecutableAction;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseHandler;
import org.elasticsearch.xpack.inference.external.http.sender.ChatCompletionInput;
import org.elasticsearch.xpack.inference.external.http.sender.EmbeddingsInput;
import org.elasticsearch.xpack.inference.external.http.sender.GenericRequestManager;
import org.elasticsearch.xpack.inference.external.http.sender.Sender;
import org.elasticsearch.xpack.inference.external.http.sender.UnifiedChatInput;
import org.elasticsearch.xpack.inference.services.ServiceComponents;
import org.elasticsearch.xpack.inference.services.huggingface.response.HuggingFaceEmbeddingsResponseEntity;
import org.elasticsearch.xpack.inference.services.llama.action.LlamaActionVisitor;
import org.elasticsearch.xpack.inference.services.llama.completion.LlamaChatCompletionModel;
import org.elasticsearch.xpack.inference.services.llama.completion.LlamaCompletionResponseHandler;
import org.elasticsearch.xpack.inference.services.llama.embeddings.LlamaEmbeddingsModel;
import org.elasticsearch.xpack.inference.services.llama.embeddings.LlamaEmbeddingsResponseHandler;
import org.elasticsearch.xpack.inference.services.llama.request.completion.LlamaChatCompletionRequest;
import org.elasticsearch.xpack.inference.services.llama.request.embeddings.LlamaEmbeddingsRequest;
import org.elasticsearch.xpack.inference.services.openai.response.OpenAiChatCompletionResponseEntity;

public class LlamaActionCreator
implements LlamaActionVisitor {
    private static final String FAILED_TO_SEND_REQUEST_ERROR_MESSAGE = "Failed to send Llama %s request from inference entity id [%s]";
    private static final String COMPLETION_ERROR_PREFIX = "Llama completions";
    private static final String USER_ROLE = "user";
    private static final ResponseHandler EMBEDDINGS_HANDLER = new LlamaEmbeddingsResponseHandler("llama text embedding", HuggingFaceEmbeddingsResponseEntity::fromResponse);
    private static final ResponseHandler COMPLETION_HANDLER = new LlamaCompletionResponseHandler("llama completion", OpenAiChatCompletionResponseEntity::fromResponse);
    private final Sender sender;
    private final ServiceComponents serviceComponents;

    public LlamaActionCreator(Sender sender, ServiceComponents serviceComponents) {
        this.sender = Objects.requireNonNull(sender);
        this.serviceComponents = Objects.requireNonNull(serviceComponents);
    }

    @Override
    public ExecutableAction create(LlamaEmbeddingsModel model) {
        GenericRequestManager<EmbeddingsInput> manager = new GenericRequestManager<EmbeddingsInput>(this.serviceComponents.threadPool(), model, EMBEDDINGS_HANDLER, embeddingsInput -> new LlamaEmbeddingsRequest(this.serviceComponents.truncator(), Truncator.truncate(embeddingsInput.getTextInputs(), model.getServiceSettings().maxInputTokens()), model), EmbeddingsInput.class);
        String errorMessage = LlamaActionCreator.buildErrorMessage(TaskType.TEXT_EMBEDDING, model.getInferenceEntityId());
        return new SenderExecutableAction(this.sender, manager, errorMessage);
    }

    @Override
    public ExecutableAction create(LlamaChatCompletionModel model) {
        GenericRequestManager<ChatCompletionInput> manager = new GenericRequestManager<ChatCompletionInput>(this.serviceComponents.threadPool(), model, COMPLETION_HANDLER, inputs -> new LlamaChatCompletionRequest(new UnifiedChatInput((ChatCompletionInput)inputs, USER_ROLE), model), ChatCompletionInput.class);
        String errorMessage = LlamaActionCreator.buildErrorMessage(TaskType.COMPLETION, model.getInferenceEntityId());
        return new SingleInputSenderExecutableAction(this.sender, manager, errorMessage, COMPLETION_ERROR_PREFIX);
    }

    public static String buildErrorMessage(TaskType requestType, String inferenceId) {
        return Strings.format((String)FAILED_TO_SEND_REQUEST_ERROR_MESSAGE, (Object[])new Object[]{requestType.toString(), inferenceId});
    }
}

