/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.elastic.request;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.message.BasicHeader;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.services.elastic.ccm.CCMAuthenticationApplierFactory;
import org.elasticsearch.xpack.inference.services.elastic.request.ElasticInferenceServiceRequest;
import org.elasticsearch.xpack.inference.services.elastic.request.ElasticInferenceServiceRequestMetadata;
import org.elasticsearch.xpack.inference.services.elastic.request.ElasticInferenceServiceRerankRequestEntity;
import org.elasticsearch.xpack.inference.services.elastic.rerank.ElasticInferenceServiceRerankModel;
import org.elasticsearch.xpack.inference.telemetry.TraceContext;
import org.elasticsearch.xpack.inference.telemetry.TraceContextHandler;

public class ElasticInferenceServiceRerankRequest
extends ElasticInferenceServiceRequest {
    private final String query;
    private final List<String> documents;
    private final Integer topN;
    private final TraceContextHandler traceContextHandler;
    private final ElasticInferenceServiceRerankModel model;

    public ElasticInferenceServiceRerankRequest(String query, List<String> documents, Integer topN, ElasticInferenceServiceRerankModel model, TraceContext traceContext, ElasticInferenceServiceRequestMetadata metadata, CCMAuthenticationApplierFactory.AuthApplier authApplier) {
        super(metadata, authApplier);
        this.query = query;
        this.documents = documents;
        this.topN = topN;
        this.model = Objects.requireNonNull(model);
        this.traceContextHandler = new TraceContextHandler(traceContext);
    }

    @Override
    public HttpRequestBase createHttpRequestBase() {
        HttpPost httpPost = new HttpPost(this.getURI());
        String requestEntity = Strings.toString((ToXContent)new ElasticInferenceServiceRerankRequestEntity(this.query, this.documents, this.model.getServiceSettings().modelId(), this.topN));
        ByteArrayEntity byteEntity = new ByteArrayEntity(requestEntity.getBytes(StandardCharsets.UTF_8));
        httpPost.setEntity((HttpEntity)byteEntity);
        this.traceContextHandler.propagateTraceContext((HttpRequestBase)httpPost);
        httpPost.setHeader((Header)new BasicHeader("Content-Type", XContentType.JSON.mediaType()));
        return httpPost;
    }

    public TraceContext getTraceContext() {
        return this.traceContextHandler.traceContext();
    }

    @Override
    public String getInferenceEntityId() {
        return this.model.getInferenceEntityId();
    }

    @Override
    public URI getURI() {
        return this.model.uri();
    }

    @Override
    public Request truncate() {
        return this;
    }

    @Override
    public boolean[] getTruncationInfo() {
        return null;
    }
}

