/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.elastic.action;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseHandler;
import org.elasticsearch.xpack.inference.external.http.sender.EmbeddingsInput;
import org.elasticsearch.xpack.inference.external.http.sender.GenericRequestManager;
import org.elasticsearch.xpack.inference.external.http.sender.QueryAndDocsInputs;
import org.elasticsearch.xpack.inference.external.http.sender.RequestManager;
import org.elasticsearch.xpack.inference.external.response.elastic.ElasticInferenceServiceDenseTextEmbeddingsResponseEntity;
import org.elasticsearch.xpack.inference.external.response.elastic.ElasticInferenceServiceRerankResponseEntity;
import org.elasticsearch.xpack.inference.services.ServiceComponents;
import org.elasticsearch.xpack.inference.services.elastic.ElasticInferenceServiceModel;
import org.elasticsearch.xpack.inference.services.elastic.ElasticInferenceServiceResponseHandler;
import org.elasticsearch.xpack.inference.services.elastic.ElasticInferenceServiceSparseEmbeddingsRequestManager;
import org.elasticsearch.xpack.inference.services.elastic.ElasticInferenceServiceUnifiedCompletionRequestManager;
import org.elasticsearch.xpack.inference.services.elastic.ccm.CCMAuthenticationApplierFactory;
import org.elasticsearch.xpack.inference.services.elastic.completion.ElasticInferenceServiceCompletionModel;
import org.elasticsearch.xpack.inference.services.elastic.densetextembeddings.ElasticInferenceServiceDenseTextEmbeddingsModel;
import org.elasticsearch.xpack.inference.services.elastic.request.ElasticInferenceServiceDenseTextEmbeddingsRequest;
import org.elasticsearch.xpack.inference.services.elastic.request.ElasticInferenceServiceRequest;
import org.elasticsearch.xpack.inference.services.elastic.request.ElasticInferenceServiceRequestMetadata;
import org.elasticsearch.xpack.inference.services.elastic.request.ElasticInferenceServiceRerankRequest;
import org.elasticsearch.xpack.inference.services.elastic.rerank.ElasticInferenceServiceRerankModel;
import org.elasticsearch.xpack.inference.services.elastic.sparseembeddings.ElasticInferenceServiceSparseEmbeddingsModel;
import org.elasticsearch.xpack.inference.telemetry.TraceContext;

record ModelStrategyFactory(ServiceComponents serviceComponents) {
    private static final String SPARSE_EMBEDDINGS_REQUEST_DESCRIPTION = Strings.format((String)"%s sparse embeddings", (Object[])new Object[]{"Elastic Inference Service"});
    private static final Strategy<ElasticInferenceServiceSparseEmbeddingsModel> SPARSE_EMBEDDINGS_STRATEGY = new Strategy<ElasticInferenceServiceSparseEmbeddingsModel>(){

        @Override
        public RequestManager createRequestManager(ElasticInferenceServiceSparseEmbeddingsModel model, ServiceComponents serviceComponents, TraceContext traceContext, CCMAuthenticationApplierFactory.AuthApplier authApplier) {
            return new ElasticInferenceServiceSparseEmbeddingsRequestManager(model, serviceComponents, traceContext, authApplier);
        }

        @Override
        public String requestDescription() {
            return SPARSE_EMBEDDINGS_REQUEST_DESCRIPTION;
        }
    };
    private static final String RERANK_REQUEST_DESCRIPTION = Strings.format((String)"%s rerank", (Object[])new Object[]{"Elastic Inference Service"});
    private static final ResponseHandler RERANK_HANDLER = new ElasticInferenceServiceResponseHandler(RERANK_REQUEST_DESCRIPTION, (request, response) -> ElasticInferenceServiceRerankResponseEntity.fromResponse(response));
    private static final Strategy<ElasticInferenceServiceRerankModel> RERANK_STRATEGY = new Strategy<ElasticInferenceServiceRerankModel>(){

        @Override
        public RequestManager createRequestManager(ElasticInferenceServiceRerankModel model, ServiceComponents serviceComponents, TraceContext traceContext, CCMAuthenticationApplierFactory.AuthApplier authApplier) {
            ElasticInferenceServiceRequestMetadata metadata = ElasticInferenceServiceRequest.extractRequestMetadataFromThreadContext(serviceComponents.threadPool().getThreadContext());
            return new GenericRequestManager<QueryAndDocsInputs>(serviceComponents.threadPool(), model, RERANK_HANDLER, rerankInput -> new ElasticInferenceServiceRerankRequest(rerankInput.getQuery(), rerankInput.getChunks(), rerankInput.getTopN(), model, traceContext, metadata, authApplier), QueryAndDocsInputs.class);
        }

        @Override
        public String requestDescription() {
            return RERANK_REQUEST_DESCRIPTION;
        }
    };
    private static final String DENSE_TEXT_EMBEDDINGS_REQUEST_DESCRIPTION = Strings.format((String)"%s dense text embeddings", (Object[])new Object[]{"Elastic Inference Service"});
    private static final ResponseHandler DENSE_TEXT_EMBEDDINGS_HANDLER = new ElasticInferenceServiceResponseHandler(DENSE_TEXT_EMBEDDINGS_REQUEST_DESCRIPTION, ElasticInferenceServiceDenseTextEmbeddingsResponseEntity::fromResponse);
    private static final Strategy<ElasticInferenceServiceDenseTextEmbeddingsModel> EMBEDDING_STRATEGY = new Strategy<ElasticInferenceServiceDenseTextEmbeddingsModel>(){

        @Override
        public RequestManager createRequestManager(ElasticInferenceServiceDenseTextEmbeddingsModel model, ServiceComponents serviceComponents, TraceContext traceContext, CCMAuthenticationApplierFactory.AuthApplier authApplier) {
            ElasticInferenceServiceRequestMetadata metadata = ElasticInferenceServiceRequest.extractRequestMetadataFromThreadContext(serviceComponents.threadPool().getThreadContext());
            return new GenericRequestManager<EmbeddingsInput>(serviceComponents.threadPool(), model, DENSE_TEXT_EMBEDDINGS_HANDLER, embeddingsInput -> new ElasticInferenceServiceDenseTextEmbeddingsRequest(model, embeddingsInput.getTextInputs(), traceContext, metadata, embeddingsInput.getInputType(), authApplier), EmbeddingsInput.class);
        }

        @Override
        public String requestDescription() {
            return DENSE_TEXT_EMBEDDINGS_REQUEST_DESCRIPTION;
        }
    };
    private static final String CHAT_COMPLETIONS_REQUEST_DESCRIPTION = Strings.format((String)"%s chat completions", (Object[])new Object[]{"Elastic Inference Service"});
    private static final Strategy<ElasticInferenceServiceCompletionModel> CHAT_COMPLETIONS_STRATEGY = new Strategy<ElasticInferenceServiceCompletionModel>(){

        @Override
        public RequestManager createRequestManager(ElasticInferenceServiceCompletionModel model, ServiceComponents serviceComponents, TraceContext traceContext, CCMAuthenticationApplierFactory.AuthApplier authApplier) {
            return ElasticInferenceServiceUnifiedCompletionRequestManager.of(model, serviceComponents.threadPool(), traceContext, authApplier);
        }

        @Override
        public String requestDescription() {
            return CHAT_COMPLETIONS_REQUEST_DESCRIPTION;
        }
    };

    public static <T extends ElasticInferenceServiceModel> Strategy<T> getStrategy(T model) {
        T t = model;
        Objects.requireNonNull(t);
        T t2 = t;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ElasticInferenceServiceSparseEmbeddingsModel.class, ElasticInferenceServiceRerankModel.class, ElasticInferenceServiceDenseTextEmbeddingsModel.class, ElasticInferenceServiceCompletionModel.class}, t2, n)) {
            case 0 -> {
                ElasticInferenceServiceSparseEmbeddingsModel ignored = (ElasticInferenceServiceSparseEmbeddingsModel)t2;
                yield SPARSE_EMBEDDINGS_STRATEGY;
            }
            case 1 -> {
                ElasticInferenceServiceRerankModel ignored = (ElasticInferenceServiceRerankModel)t2;
                yield RERANK_STRATEGY;
            }
            case 2 -> {
                ElasticInferenceServiceDenseTextEmbeddingsModel ignored = (ElasticInferenceServiceDenseTextEmbeddingsModel)t2;
                yield EMBEDDING_STRATEGY;
            }
            case 3 -> {
                ElasticInferenceServiceCompletionModel ignored = (ElasticInferenceServiceCompletionModel)t2;
                yield CHAT_COMPLETIONS_STRATEGY;
            }
            default -> throw new IllegalArgumentException("No strategy found for model type: " + ((Object)model).getClass().getSimpleName());
        };
    }

    public static interface Strategy<T extends ElasticInferenceServiceModel> {
        public RequestManager createRequestManager(T var1, ServiceComponents var2, TraceContext var3, CCMAuthenticationApplierFactory.AuthApplier var4);

        public String requestDescription();
    }
}

