/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.cohere;

import java.io.IOException;
import java.net.URI;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.SimilarityMeasure;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.cohere.CohereRateLimitServiceSettings;
import org.elasticsearch.xpack.inference.services.settings.FilteredXContentObject;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public class CohereServiceSettings
extends FilteredXContentObject
implements ServiceSettings,
CohereRateLimitServiceSettings {
    public static final String NAME = "cohere_service_settings";
    public static final String OLD_MODEL_ID_FIELD = "model";
    public static final String MODEL_ID = "model_id";
    public static final String API_VERSION = "api_version";
    public static final String MODEL_REQUIRED_FOR_V2_API = "The [service_settings.model_id] field is required for the Cohere V2 API.";
    private static final TransportVersion ML_INFERENCE_COHERE_API_VERSION = TransportVersion.fromName((String)"ml_inference_cohere_api_version");
    private static final Logger logger = LogManager.getLogger(CohereServiceSettings.class);
    public static final RateLimitSettings DEFAULT_RATE_LIMIT_SETTINGS = new RateLimitSettings(10000L);
    private final URI uri;
    private final SimilarityMeasure similarity;
    private final Integer dimensions;
    private final Integer maxInputTokens;
    private final String modelId;
    private final RateLimitSettings rateLimitSettings;
    private final CohereApiVersion apiVersion;

    public static CohereServiceSettings fromMap(Map<String, Object> map, ConfigurationParseContext context) {
        ValidationException validationException = new ValidationException();
        String url = ServiceUtils.extractOptionalString(map, "url", "service_settings", validationException);
        SimilarityMeasure similarity = ServiceUtils.extractSimilarity(map, "service_settings", validationException);
        Integer dims = ServiceUtils.removeAsType(map, "dimensions", Integer.class);
        Integer maxInputTokens = ServiceUtils.removeAsType(map, "max_input_tokens", Integer.class);
        URI uri = ServiceUtils.convertToUri(url, "url", "service_settings", validationException);
        String oldModelId = ServiceUtils.extractOptionalString(map, OLD_MODEL_ID_FIELD, "service_settings", validationException);
        RateLimitSettings rateLimitSettings = RateLimitSettings.of(map, DEFAULT_RATE_LIMIT_SETTINGS, validationException, "cohere", context);
        String modelId = ServiceUtils.extractOptionalString(map, MODEL_ID, "service_settings", validationException);
        if (context == ConfigurationParseContext.REQUEST && oldModelId != null) {
            logger.info("The cohere [service_settings.model] field is deprecated. Please use [service_settings.model_id] instead.");
        }
        String resolvedModelId = CohereServiceSettings.modelId(oldModelId, modelId);
        CohereApiVersion apiVersion = CohereServiceSettings.apiVersionFromMap(map, context, validationException);
        if (apiVersion == CohereApiVersion.V2 && resolvedModelId == null) {
            validationException.addValidationError(MODEL_REQUIRED_FOR_V2_API);
        }
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new CohereServiceSettings(uri, similarity, dims, maxInputTokens, resolvedModelId, rateLimitSettings, apiVersion);
    }

    public static CohereApiVersion apiVersionFromMap(Map<String, Object> map, ConfigurationParseContext context, ValidationException validationException) {
        return switch (context) {
            default -> throw new MatchException(null, null);
            case ConfigurationParseContext.REQUEST -> CohereApiVersion.V2;
            case ConfigurationParseContext.PERSISTENT -> {
                CohereApiVersion apiVersion = ServiceUtils.extractOptionalEnum(map, API_VERSION, "service_settings", CohereApiVersion::fromString, EnumSet.allOf(CohereApiVersion.class), validationException);
                if (apiVersion == null) {
                    yield CohereApiVersion.V1;
                }
                yield apiVersion;
            }
        };
    }

    private static String modelId(@Nullable String model, @Nullable String modelId) {
        return modelId != null ? modelId : model;
    }

    public CohereServiceSettings(@Nullable URI uri, @Nullable SimilarityMeasure similarity, @Nullable Integer dimensions, @Nullable Integer maxInputTokens, @Nullable String modelId, @Nullable RateLimitSettings rateLimitSettings, CohereApiVersion apiVersion) {
        this.uri = uri;
        this.similarity = similarity;
        this.dimensions = dimensions;
        this.maxInputTokens = maxInputTokens;
        this.modelId = modelId;
        this.rateLimitSettings = Objects.requireNonNullElse(rateLimitSettings, DEFAULT_RATE_LIMIT_SETTINGS);
        this.apiVersion = apiVersion;
    }

    public CohereServiceSettings(@Nullable String url, @Nullable SimilarityMeasure similarity, @Nullable Integer dimensions, @Nullable Integer maxInputTokens, @Nullable String modelId, @Nullable RateLimitSettings rateLimitSettings, CohereApiVersion apiVersion) {
        this(ServiceUtils.createOptionalUri(url), similarity, dimensions, maxInputTokens, modelId, rateLimitSettings, apiVersion);
    }

    public CohereServiceSettings(StreamInput in) throws IOException {
        this.uri = ServiceUtils.createOptionalUri(in.readOptionalString());
        this.similarity = (SimilarityMeasure)in.readOptionalEnum(SimilarityMeasure.class);
        this.dimensions = in.readOptionalVInt();
        this.maxInputTokens = in.readOptionalVInt();
        this.modelId = in.readOptionalString();
        this.rateLimitSettings = new RateLimitSettings(in);
        this.apiVersion = in.getTransportVersion().supports(ML_INFERENCE_COHERE_API_VERSION) ? (CohereApiVersion)in.readEnum(CohereApiVersion.class) : CohereApiVersion.V1;
    }

    public CohereServiceSettings(CohereApiVersion apiVersion) {
        this((URI)null, null, null, null, null, null, apiVersion);
    }

    @Override
    public RateLimitSettings rateLimitSettings() {
        return this.rateLimitSettings;
    }

    @Override
    public CohereApiVersion apiVersion() {
        return this.apiVersion;
    }

    @Override
    public URI uri() {
        return this.uri;
    }

    public SimilarityMeasure similarity() {
        return this.similarity;
    }

    public Integer dimensions() {
        return this.dimensions;
    }

    public Integer maxInputTokens() {
        return this.maxInputTokens;
    }

    public String modelId() {
        return this.modelId;
    }

    public String getWriteableName() {
        return NAME;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.toXContentFragment(builder, params);
        builder.endObject();
        return builder;
    }

    public XContentBuilder toXContentFragment(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.toXContentFragmentOfExposedFields(builder, params);
        return builder.field(API_VERSION, (Enum)this.apiVersion);
    }

    @Override
    public XContentBuilder toXContentFragmentOfExposedFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.uri != null) {
            builder.field("url", this.uri.toString());
        }
        if (this.similarity != null) {
            builder.field("similarity", (Enum)this.similarity);
        }
        if (this.dimensions != null) {
            builder.field("dimensions", this.dimensions);
        }
        if (this.maxInputTokens != null) {
            builder.field("max_input_tokens", this.maxInputTokens);
        }
        if (this.modelId != null) {
            builder.field(MODEL_ID, this.modelId);
        }
        this.rateLimitSettings.toXContent(builder, params);
        return builder;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_13_0;
    }

    public void writeTo(StreamOutput out) throws IOException {
        String uriToWrite = this.uri != null ? this.uri.toString() : null;
        out.writeOptionalString(uriToWrite);
        out.writeOptionalEnum((Enum)SimilarityMeasure.translateSimilarity((SimilarityMeasure)this.similarity, (TransportVersion)out.getTransportVersion()));
        out.writeOptionalVInt(this.dimensions);
        out.writeOptionalVInt(this.maxInputTokens);
        out.writeOptionalString(this.modelId);
        this.rateLimitSettings.writeTo(out);
        if (out.getTransportVersion().supports(ML_INFERENCE_COHERE_API_VERSION)) {
            out.writeEnum((Enum)this.apiVersion);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CohereServiceSettings that = (CohereServiceSettings)o;
        return Objects.equals(this.uri, that.uri) && Objects.equals(this.similarity, that.similarity) && Objects.equals(this.dimensions, that.dimensions) && Objects.equals(this.maxInputTokens, that.maxInputTokens) && Objects.equals(this.modelId, that.modelId) && Objects.equals(this.rateLimitSettings, that.rateLimitSettings) && this.apiVersion == that.apiVersion;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.uri, this.similarity, this.dimensions, this.maxInputTokens, this.modelId, this.rateLimitSettings, this.apiVersion});
    }

    public static enum CohereApiVersion {
        V1,
        V2;


        public static CohereApiVersion fromString(String name) {
            return CohereApiVersion.valueOf(name.trim().toUpperCase(Locale.ROOT));
        }
    }
}

