/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.anthropic;

import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.inference.results.StreamingUnifiedChatCompletionResults;
import org.elasticsearch.xpack.inference.common.DelegatingProcessor;
import org.elasticsearch.xpack.inference.external.response.streaming.ServerSentEvent;

public class AnthropicChatCompletionStreamingProcessor
extends DelegatingProcessor<Deque<ServerSentEvent>, StreamingUnifiedChatCompletionResults.Results> {
    private static final String FAILED_TO_FIND_FIELD_TEMPLATE = "Failed to find required field [%s] in Anthropic chat completions response";
    private static final String UNEXPECTED_FIELD_TYPE_TEMPLATE = "Field [%s] in Anthropic chat completions response is of unexpected type [%s]. Expected type is [%s].";
    private static final Logger logger = LogManager.getLogger(AnthropicChatCompletionStreamingProcessor.class);
    private static final String ROLE_FIELD = "role";
    private static final String INDEX_FIELD = "index";
    private static final String TYPE_FIELD = "type";
    private static final String MODEL_FIELD = "model";
    private static final String ID_FIELD = "id";
    private static final String NAME_FIELD = "name";
    private static final String INPUT_TOKENS_FIELD = "input_tokens";
    private static final String OUTPUT_TOKENS_FIELD = "output_tokens";
    private static final String STOP_REASON_FIELD = "stop_reason";
    private static final String TEXT_FIELD = "text";
    private static final String INPUT_FIELD = "input";
    private static final String PARTIAL_JSON_FIELD = "partial_json";
    private static final String USAGE_FIELD = "usage";
    private static final String MESSAGE_FIELD = "message";
    private static final String CONTENT_BLOCK_FIELD = "content_block";
    private static final String DELTA_FIELD = "delta";
    private static final String MESSAGE_DELTA_EVENT_TYPE = "message_delta";
    private static final String CONTENT_BLOCK_START_EVENT_TYPE = "content_block_start";
    private static final String MESSAGE_START_EVENT_TYPE = "message_start";
    private static final String VERTEX_EVENT_EVENT_TYPE = "vertex_event";
    private static final String PING_EVENT_TYPE = "ping";
    private static final String CONTENT_BLOCK_STOP_EVENT_TYPE = "content_block_stop";
    private static final String CONTENT_BLOCK_DELTA_EVENT_TYPE = "content_block_delta";
    private static final String MESSAGE_STOP_EVENT_TYPE = "message_stop";
    private static final String ERROR_EVENT_TYPE = "error";
    private static final String TEXT_DELTA_TYPE = "text_delta";
    private static final String INPUT_JSON_DELTA_TYPE = "input_json_delta";
    private static final String TOOL_USE_TYPE = "tool_use";
    private static final String TEXT_TYPE = "text";
    private final BiFunction<String, Exception, Exception> errorParser;

    public AnthropicChatCompletionStreamingProcessor(BiFunction<String, Exception, Exception> errorParser) {
        this.errorParser = errorParser;
    }

    @Override
    protected void next(Deque<ServerSentEvent> item) throws Exception {
        XContentParserConfiguration parserConfig = XContentParserConfiguration.EMPTY.withDeprecationHandler((DeprecationHandler)LoggingDeprecationHandler.INSTANCE);
        ArrayDeque results = new ArrayDeque(item.size());
        for (ServerSentEvent event : item) {
            if (ERROR_EVENT_TYPE.equals(event.type()) && event.hasData()) {
                throw this.errorParser.apply(event.data(), null);
            }
            if (!event.hasData()) continue;
            try {
                Stream<StreamingUnifiedChatCompletionResults.ChatCompletionChunk> delta = AnthropicChatCompletionStreamingProcessor.parse(parserConfig, event);
                delta.forEach(results::offer);
            }
            catch (Exception e) {
                logger.warn("Failed to parse event from Anthropic inference provider: {}", (Object)event);
                throw this.errorParser.apply(event.data(), e);
            }
        }
        if (results.isEmpty()) {
            this.upstream().request(1L);
        } else {
            this.downstream().onNext(new StreamingUnifiedChatCompletionResults.Results(results));
        }
    }

    private static Stream<StreamingUnifiedChatCompletionResults.ChatCompletionChunk> parse(XContentParserConfiguration parserConfig, ServerSentEvent event) throws IOException {
        String string = event.type();
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{VERTEX_EVENT_EVENT_TYPE, PING_EVENT_TYPE, CONTENT_BLOCK_STOP_EVENT_TYPE, MESSAGE_START_EVENT_TYPE, CONTENT_BLOCK_START_EVENT_TYPE, CONTENT_BLOCK_DELTA_EVENT_TYPE, MESSAGE_DELTA_EVENT_TYPE, MESSAGE_STOP_EVENT_TYPE}, (Object)string, n)) {
            case 0: 
            case 1: 
            case 2: {
                logger.debug("Skipping event type [{}] for line [{}].", (Object)event.type(), (Object)event.data());
                return Stream.empty();
            }
            case 3: {
                return AnthropicChatCompletionStreamingProcessor.parseMessageStart(parserConfig, event.data());
            }
            case 4: {
                return AnthropicChatCompletionStreamingProcessor.parseContentBlockStart(parserConfig, event.data());
            }
            case 5: {
                return AnthropicChatCompletionStreamingProcessor.parseContentBlockDelta(parserConfig, event.data());
            }
            case 6: {
                return AnthropicChatCompletionStreamingProcessor.parseMessageDelta(parserConfig, event.data());
            }
            case 7: {
                return Stream.empty();
            }
        }
        logger.debug("Unknown event type [{}] for line [{}].", (Object)event.type(), (Object)event.data());
        return Stream.empty();
    }

    private static Stream<StreamingUnifiedChatCompletionResults.ChatCompletionChunk> parseMessageStart(XContentParserConfiguration parserConfig, String data) throws IOException {
        try (XContentParser jsonParser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(parserConfig, data);){
            Map<String, Object> messageMap = AnthropicChatCompletionStreamingProcessor.extractInnerStringObjectMap(jsonParser.map(), MESSAGE_FIELD);
            String model = AnthropicChatCompletionStreamingProcessor.extractMandatoryString(messageMap, MODEL_FIELD);
            String id = AnthropicChatCompletionStreamingProcessor.extractMandatoryString(messageMap, ID_FIELD);
            String role = AnthropicChatCompletionStreamingProcessor.extractMandatoryString(messageMap, ROLE_FIELD);
            String finishReason = AnthropicChatCompletionStreamingProcessor.extractOptionalString(messageMap, STOP_REASON_FIELD);
            Map<String, Object> usageMap = AnthropicChatCompletionStreamingProcessor.extractInnerStringObjectMap(messageMap, USAGE_FIELD);
            Integer promptTokens = AnthropicChatCompletionStreamingProcessor.extractMandatoryInteger(usageMap, INPUT_TOKENS_FIELD);
            Integer completionTokens = AnthropicChatCompletionStreamingProcessor.extractMandatoryInteger(usageMap, OUTPUT_TOKENS_FIELD);
            int totalTokens = completionTokens + promptTokens;
            StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Usage usage = new StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Usage(completionTokens.intValue(), promptTokens.intValue(), totalTokens);
            StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice.Delta delta = new StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice.Delta(null, null, role, null);
            StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice choice = new StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice(delta, finishReason, 0);
            StreamingUnifiedChatCompletionResults.ChatCompletionChunk chunk = new StreamingUnifiedChatCompletionResults.ChatCompletionChunk(id, List.of(choice), model, null, usage);
            Stream<StreamingUnifiedChatCompletionResults.ChatCompletionChunk> stream = Stream.of(chunk);
            return stream;
        }
    }

    private static Stream<StreamingUnifiedChatCompletionResults.ChatCompletionChunk> parseContentBlockStart(XContentParserConfiguration parserConfig, String data) throws IOException {
        try (XContentParser jsonParser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(parserConfig, data);){
            StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice.Delta delta;
            Map outerMap = jsonParser.map();
            Integer index = AnthropicChatCompletionStreamingProcessor.extractMandatoryInteger(outerMap, INDEX_FIELD);
            Map<String, Object> contentBlockMap = AnthropicChatCompletionStreamingProcessor.extractInnerStringObjectMap(outerMap, CONTENT_BLOCK_FIELD);
            String type = AnthropicChatCompletionStreamingProcessor.extractMandatoryString(contentBlockMap, TYPE_FIELD);
            if (type.equals("text")) {
                String text = AnthropicChatCompletionStreamingProcessor.extractMandatoryString(contentBlockMap, "text");
                delta = new StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice.Delta(text, null, null, null);
            } else if (type.equals(TOOL_USE_TYPE)) {
                String id = AnthropicChatCompletionStreamingProcessor.extractMandatoryString(contentBlockMap, ID_FIELD);
                String name = AnthropicChatCompletionStreamingProcessor.extractMandatoryString(contentBlockMap, NAME_FIELD);
                Object input = AnthropicChatCompletionStreamingProcessor.extractOptionalField(contentBlockMap, INPUT_FIELD, Object.class);
                StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice.Delta.ToolCall.Function function = new StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice.Delta.ToolCall.Function(input != null ? input.toString() : null, name);
                StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice.Delta.ToolCall toolCall = new StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice.Delta.ToolCall(0, id, function, null);
                delta = new StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice.Delta(null, null, null, List.of(toolCall));
            } else {
                logger.debug("Unknown content block start type [{}] for line [{}].", (Object)type, (Object)data);
                Stream<StreamingUnifiedChatCompletionResults.ChatCompletionChunk> id = Stream.empty();
                return id;
            }
            StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice choice = new StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice(delta, null, index.intValue());
            StreamingUnifiedChatCompletionResults.ChatCompletionChunk chunk = new StreamingUnifiedChatCompletionResults.ChatCompletionChunk(null, List.of(choice), null, null, null);
            Stream<StreamingUnifiedChatCompletionResults.ChatCompletionChunk> stream = Stream.of(chunk);
            return stream;
        }
    }

    private static Stream<StreamingUnifiedChatCompletionResults.ChatCompletionChunk> parseContentBlockDelta(XContentParserConfiguration parserConfig, String data) throws IOException {
        try (XContentParser jsonParser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(parserConfig, data);){
            StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice.Delta delta;
            Map outerMap = jsonParser.map();
            Integer index = AnthropicChatCompletionStreamingProcessor.extractMandatoryInteger(outerMap, INDEX_FIELD);
            Map<String, Object> deltaMap = AnthropicChatCompletionStreamingProcessor.extractInnerStringObjectMap(outerMap, DELTA_FIELD);
            String type = AnthropicChatCompletionStreamingProcessor.extractMandatoryString(deltaMap, TYPE_FIELD);
            if (type.equals(TEXT_DELTA_TYPE)) {
                String text = AnthropicChatCompletionStreamingProcessor.extractMandatoryString(deltaMap, "text");
                delta = new StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice.Delta(text, null, null, null);
            } else if (type.equals(INPUT_JSON_DELTA_TYPE)) {
                String partialJson = AnthropicChatCompletionStreamingProcessor.extractMandatoryString(deltaMap, PARTIAL_JSON_FIELD);
                StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice.Delta.ToolCall.Function function = new StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice.Delta.ToolCall.Function(partialJson, null);
                StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice.Delta.ToolCall toolCall = new StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice.Delta.ToolCall(0, null, function, null);
                delta = new StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice.Delta(null, null, null, List.of(toolCall));
            } else {
                logger.debug("Unknown content block delta type [{}] for line [{}].", (Object)type, (Object)data);
                Stream<StreamingUnifiedChatCompletionResults.ChatCompletionChunk> partialJson = Stream.empty();
                return partialJson;
            }
            StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice choice = new StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice(delta, null, index.intValue());
            StreamingUnifiedChatCompletionResults.ChatCompletionChunk chunk = new StreamingUnifiedChatCompletionResults.ChatCompletionChunk(null, List.of(choice), null, null, null);
            Stream<StreamingUnifiedChatCompletionResults.ChatCompletionChunk> stream = Stream.of(chunk);
            return stream;
        }
    }

    public static Stream<StreamingUnifiedChatCompletionResults.ChatCompletionChunk> parseMessageDelta(XContentParserConfiguration parserConfig, String data) throws IOException {
        try (XContentParser jsonParser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(parserConfig, data);){
            Map outerMap = jsonParser.map();
            Map<String, Object> deltaMap = AnthropicChatCompletionStreamingProcessor.extractInnerStringObjectMap(outerMap, DELTA_FIELD);
            String finishReason = AnthropicChatCompletionStreamingProcessor.extractOptionalString(deltaMap, STOP_REASON_FIELD);
            Map<String, Object> usageMap = AnthropicChatCompletionStreamingProcessor.extractInnerStringObjectMap(outerMap, USAGE_FIELD);
            Integer totalTokens = AnthropicChatCompletionStreamingProcessor.extractMandatoryInteger(usageMap, OUTPUT_TOKENS_FIELD);
            StreamingUnifiedChatCompletionResults.ChatCompletionChunk chunk = AnthropicChatCompletionStreamingProcessor.buildChatCompletionChunk(totalTokens, finishReason);
            Stream<StreamingUnifiedChatCompletionResults.ChatCompletionChunk> stream = Stream.of(chunk);
            return stream;
        }
    }

    private static StreamingUnifiedChatCompletionResults.ChatCompletionChunk buildChatCompletionChunk(int totalTokens, @Nullable String finishReason) {
        StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Usage usage = new StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Usage(totalTokens, 0, totalTokens);
        StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice choice = new StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice(new StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice.Delta(null, null, null, null), finishReason, 0);
        return new StreamingUnifiedChatCompletionResults.ChatCompletionChunk(null, List.of(choice), null, null, usage);
    }

    private static String extractMandatoryString(Map<String, Object> map, String fieldName) {
        return AnthropicChatCompletionStreamingProcessor.extractMandatoryField(map, fieldName, String.class);
    }

    private static Integer extractMandatoryInteger(Map<String, Object> map, String fieldName) {
        return AnthropicChatCompletionStreamingProcessor.extractMandatoryField(map, fieldName, Integer.class);
    }

    private static String extractOptionalString(Map<String, Object> map, String fieldName) {
        return AnthropicChatCompletionStreamingProcessor.extractOptionalField(map, fieldName, String.class);
    }

    private static Map<String, Object> extractInnerStringObjectMap(Map<String, Object> outerMap, String fieldName) {
        return AnthropicChatCompletionStreamingProcessor.extractMandatoryField(outerMap, fieldName, Map.class);
    }

    private static <T> T extractMandatoryField(Map<String, Object> map, String fieldName, Class<T> type) {
        Object value = map.get(fieldName);
        if (value == null) {
            throw new IllegalStateException(Strings.format((String)FAILED_TO_FIND_FIELD_TEMPLATE, (Object[])new Object[]{fieldName}));
        }
        return AnthropicChatCompletionStreamingProcessor.castFieldValueOrThrow(value, type, fieldName);
    }

    private static <T> T extractOptionalField(Map<String, Object> map, String fieldName, Class<T> type) {
        Object value = map.get(fieldName);
        if (value == null) {
            return null;
        }
        return AnthropicChatCompletionStreamingProcessor.castFieldValueOrThrow(value, type, fieldName);
    }

    private static <T> T castFieldValueOrThrow(Object value, Class<T> type, String fieldName) {
        if (!type.isInstance(value)) {
            throw new IllegalStateException(Strings.format((String)UNEXPECTED_FIELD_TYPE_TEMPLATE, (Object[])new Object[]{fieldName, value.getClass().getSimpleName(), type.getSimpleName()}));
        }
        return (T)value;
    }
}

