/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.alibabacloudsearch;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.util.LazyInitializable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.inference.ChunkInferenceInput;
import org.elasticsearch.inference.ChunkedInference;
import org.elasticsearch.inference.ChunkingSettings;
import org.elasticsearch.inference.InferenceServiceConfiguration;
import org.elasticsearch.inference.InferenceServiceExtension;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.RerankingInferenceService;
import org.elasticsearch.inference.SettingsConfiguration;
import org.elasticsearch.inference.SimilarityMeasure;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.inference.configuration.SettingsConfigurationFieldType;
import org.elasticsearch.xpack.core.inference.chunking.ChunkingSettingsBuilder;
import org.elasticsearch.xpack.core.inference.chunking.EmbeddingRequestChunker;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.http.sender.EmbeddingsInput;
import org.elasticsearch.xpack.inference.external.http.sender.HttpRequestSender;
import org.elasticsearch.xpack.inference.external.http.sender.InferenceInputs;
import org.elasticsearch.xpack.inference.external.http.sender.UnifiedChatInput;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.SenderService;
import org.elasticsearch.xpack.inference.services.ServiceComponents;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.alibabacloudsearch.AlibabaCloudSearchModel;
import org.elasticsearch.xpack.inference.services.alibabacloudsearch.AlibabaCloudSearchServiceSettings;
import org.elasticsearch.xpack.inference.services.alibabacloudsearch.action.AlibabaCloudSearchActionCreator;
import org.elasticsearch.xpack.inference.services.alibabacloudsearch.completion.AlibabaCloudSearchCompletionModel;
import org.elasticsearch.xpack.inference.services.alibabacloudsearch.embeddings.AlibabaCloudSearchEmbeddingsModel;
import org.elasticsearch.xpack.inference.services.alibabacloudsearch.embeddings.AlibabaCloudSearchEmbeddingsServiceSettings;
import org.elasticsearch.xpack.inference.services.alibabacloudsearch.rerank.AlibabaCloudSearchRerankModel;
import org.elasticsearch.xpack.inference.services.alibabacloudsearch.sparse.AlibabaCloudSearchSparseModel;
import org.elasticsearch.xpack.inference.services.settings.DefaultSecretSettings;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public class AlibabaCloudSearchService
extends SenderService
implements RerankingInferenceService {
    public static final String NAME = "alibabacloud-ai-search";
    private static final String SERVICE_NAME = "AlibabaCloud AI Search";
    private static final EnumSet<TaskType> supportedTaskTypes = EnumSet.of(TaskType.TEXT_EMBEDDING, TaskType.SPARSE_EMBEDDING, TaskType.RERANK, TaskType.COMPLETION);
    public static final EnumSet<InputType> VALID_INPUT_TYPE_VALUES = EnumSet.of(InputType.INGEST, InputType.SEARCH, InputType.INTERNAL_INGEST, InputType.INTERNAL_SEARCH);

    public AlibabaCloudSearchService(HttpRequestSender.Factory factory, ServiceComponents serviceComponents, InferenceServiceExtension.InferenceServiceFactoryContext context) {
        this(factory, serviceComponents, context.clusterService());
    }

    public AlibabaCloudSearchService(HttpRequestSender.Factory factory, ServiceComponents serviceComponents, ClusterService clusterService) {
        super(factory, serviceComponents, clusterService);
    }

    public String name() {
        return NAME;
    }

    public void parseRequestConfig(String inferenceEntityId, TaskType taskType, Map<String, Object> config, ActionListener<Model> parsedModelListener) {
        try {
            Map<String, Object> serviceSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "service_settings");
            Map<String, Object> taskSettingsMap = ServiceUtils.removeFromMapOrDefaultEmpty(config, "task_settings");
            ChunkingSettings chunkingSettings = null;
            if (List.of(TaskType.TEXT_EMBEDDING, TaskType.SPARSE_EMBEDDING).contains(taskType)) {
                chunkingSettings = ChunkingSettingsBuilder.fromMap(ServiceUtils.removeFromMapOrDefaultEmpty(config, "chunking_settings"));
            }
            AlibabaCloudSearchModel model = AlibabaCloudSearchService.createModel(inferenceEntityId, taskType, serviceSettingsMap, taskSettingsMap, chunkingSettings, serviceSettingsMap, ConfigurationParseContext.REQUEST);
            ServiceUtils.throwIfNotEmptyMap(config, NAME);
            ServiceUtils.throwIfNotEmptyMap(serviceSettingsMap, NAME);
            ServiceUtils.throwIfNotEmptyMap(taskSettingsMap, NAME);
            parsedModelListener.onResponse((Object)model);
        }
        catch (Exception e) {
            parsedModelListener.onFailure(e);
        }
    }

    public InferenceServiceConfiguration getConfiguration() {
        return Configuration.get();
    }

    public EnumSet<TaskType> supportedTaskTypes() {
        return supportedTaskTypes;
    }

    private static AlibabaCloudSearchModel createModelWithoutLoggingDeprecations(String inferenceEntityId, TaskType taskType, Map<String, Object> serviceSettings, Map<String, Object> taskSettings, ChunkingSettings chunkingSettings, @Nullable Map<String, Object> secretSettings) {
        return AlibabaCloudSearchService.createModel(inferenceEntityId, taskType, serviceSettings, taskSettings, chunkingSettings, secretSettings, ConfigurationParseContext.PERSISTENT);
    }

    private static AlibabaCloudSearchModel createModel(String inferenceEntityId, TaskType taskType, Map<String, Object> serviceSettings, Map<String, Object> taskSettings, ChunkingSettings chunkingSettings, @Nullable Map<String, Object> secretSettings, ConfigurationParseContext context) {
        return switch (taskType) {
            case TaskType.TEXT_EMBEDDING -> new AlibabaCloudSearchEmbeddingsModel(inferenceEntityId, taskType, NAME, serviceSettings, taskSettings, chunkingSettings, secretSettings, context);
            case TaskType.SPARSE_EMBEDDING -> new AlibabaCloudSearchSparseModel(inferenceEntityId, taskType, NAME, serviceSettings, taskSettings, chunkingSettings, secretSettings, context);
            case TaskType.RERANK -> new AlibabaCloudSearchRerankModel(inferenceEntityId, taskType, NAME, serviceSettings, taskSettings, secretSettings, context);
            case TaskType.COMPLETION -> new AlibabaCloudSearchCompletionModel(inferenceEntityId, taskType, NAME, serviceSettings, taskSettings, secretSettings, context);
            default -> throw ServiceUtils.createInvalidTaskTypeException(inferenceEntityId, NAME, taskType, context);
        };
    }

    public AlibabaCloudSearchModel parsePersistedConfigWithSecrets(String inferenceEntityId, TaskType taskType, Map<String, Object> config, Map<String, Object> secrets) {
        Map<String, Object> serviceSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "service_settings");
        Map<String, Object> taskSettingsMap = ServiceUtils.removeFromMapOrDefaultEmpty(config, "task_settings");
        Map<String, Object> secretSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(secrets, "secret_settings");
        ChunkingSettings chunkingSettings = null;
        if (List.of(TaskType.TEXT_EMBEDDING, TaskType.SPARSE_EMBEDDING).contains(taskType)) {
            chunkingSettings = ChunkingSettingsBuilder.fromMap(ServiceUtils.removeFromMap(config, "chunking_settings"));
        }
        return AlibabaCloudSearchService.createModelWithoutLoggingDeprecations(inferenceEntityId, taskType, serviceSettingsMap, taskSettingsMap, chunkingSettings, secretSettingsMap);
    }

    public AlibabaCloudSearchModel parsePersistedConfig(String inferenceEntityId, TaskType taskType, Map<String, Object> config) {
        Map<String, Object> serviceSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "service_settings");
        Map<String, Object> taskSettingsMap = ServiceUtils.removeFromMapOrDefaultEmpty(config, "task_settings");
        ChunkingSettings chunkingSettings = null;
        if (List.of(TaskType.TEXT_EMBEDDING, TaskType.SPARSE_EMBEDDING).contains(taskType)) {
            chunkingSettings = ChunkingSettingsBuilder.fromMap(ServiceUtils.removeFromMap(config, "chunking_settings"));
        }
        return AlibabaCloudSearchService.createModelWithoutLoggingDeprecations(inferenceEntityId, taskType, serviceSettingsMap, taskSettingsMap, chunkingSettings, null);
    }

    @Override
    protected void doUnifiedCompletionInfer(Model model, UnifiedChatInput inputs, TimeValue timeout, ActionListener<InferenceServiceResults> listener) {
        ServiceUtils.throwUnsupportedUnifiedCompletionOperation(NAME);
    }

    @Override
    public void doInfer(Model model, InferenceInputs inputs, Map<String, Object> taskSettings, TimeValue timeout, ActionListener<InferenceServiceResults> listener) {
        if (!(model instanceof AlibabaCloudSearchModel)) {
            listener.onFailure((Exception)ServiceUtils.createInvalidModelException(model));
            return;
        }
        AlibabaCloudSearchModel alibabaCloudSearchModel = (AlibabaCloudSearchModel)model;
        AlibabaCloudSearchActionCreator actionCreator = new AlibabaCloudSearchActionCreator(this.getSender(), this.getServiceComponents());
        ExecutableAction action = alibabaCloudSearchModel.accept(actionCreator, taskSettings);
        action.execute(inputs, timeout, listener);
    }

    @Override
    protected void validateInputType(InputType inputType, Model model, ValidationException validationException) {
        ServiceUtils.validateInputTypeAgainstAllowlist(inputType, VALID_INPUT_TYPE_VALUES, SERVICE_NAME, validationException);
    }

    @Override
    protected void validateRerankParameters(Boolean returnDocuments, Integer topN, ValidationException validationException) {
        if (returnDocuments != null) {
            validationException.addValidationError(Strings.format((String)"Invalid return_documents [%s]. The return_documents option is not supported by this service", (Object[])new Object[]{returnDocuments}));
        }
        if (topN != null) {
            validationException.addValidationError(Strings.format((String)"Invalid top_n [%s]. The top_n option is not supported by this service", (Object[])new Object[]{topN}));
        }
    }

    @Override
    protected void doChunkedInfer(Model model, List<ChunkInferenceInput> inputs, Map<String, Object> taskSettings, InputType inputType, TimeValue timeout, ActionListener<List<ChunkedInference>> listener) {
        if (!(model instanceof AlibabaCloudSearchModel)) {
            listener.onFailure((Exception)ServiceUtils.createInvalidModelException(model));
            return;
        }
        AlibabaCloudSearchModel alibabaCloudSearchModel = (AlibabaCloudSearchModel)model;
        AlibabaCloudSearchActionCreator actionCreator = new AlibabaCloudSearchActionCreator(this.getSender(), this.getServiceComponents());
        List batchedRequests = new EmbeddingRequestChunker(inputs, 32, alibabaCloudSearchModel.getConfigurations().getChunkingSettings()).batchRequestsWithListeners(listener);
        for (EmbeddingRequestChunker.BatchRequestAndListener request : batchedRequests) {
            ExecutableAction action = alibabaCloudSearchModel.accept(actionCreator, taskSettings);
            action.execute(new EmbeddingsInput(request.batch().inputs(), inputType), timeout, (ActionListener<InferenceServiceResults>)request.listener());
        }
    }

    public Model updateModelWithEmbeddingDetails(Model model, int embeddingSize) {
        if (model instanceof AlibabaCloudSearchEmbeddingsModel) {
            AlibabaCloudSearchEmbeddingsModel embeddingsModel = (AlibabaCloudSearchEmbeddingsModel)model;
            AlibabaCloudSearchEmbeddingsServiceSettings serviceSettings = embeddingsModel.getServiceSettings();
            AlibabaCloudSearchEmbeddingsServiceSettings updatedServiceSettings = new AlibabaCloudSearchEmbeddingsServiceSettings(new AlibabaCloudSearchServiceSettings(serviceSettings.getCommonSettings().modelId(), serviceSettings.getCommonSettings().getHost(), serviceSettings.getCommonSettings().getWorkspaceName(), serviceSettings.getCommonSettings().getHttpSchema(), serviceSettings.getCommonSettings().rateLimitSettings()), SimilarityMeasure.DOT_PRODUCT, embeddingSize, serviceSettings.getMaxInputTokens());
            return new AlibabaCloudSearchEmbeddingsModel(embeddingsModel, updatedServiceSettings);
        }
        throw ServiceUtils.invalidModelTypeForUpdateModelWithEmbeddingDetails(model.getClass());
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_16_0;
    }

    public int rerankerWindowSize(String modelId) {
        return 5500;
    }

    public static class Configuration {
        private static final LazyInitializable<InferenceServiceConfiguration, RuntimeException> configuration = new LazyInitializable(() -> {
            HashMap<String, SettingsConfiguration> configurationMap = new HashMap<String, SettingsConfiguration>();
            configurationMap.put("service_id", new SettingsConfiguration.Builder(supportedTaskTypes).setDescription("The name of the model service to use for the {infer} task.").setLabel("Project ID").setRequired(Boolean.valueOf(true)).setSensitive(Boolean.valueOf(false)).setUpdatable(Boolean.valueOf(false)).setType(SettingsConfigurationFieldType.STRING).build());
            configurationMap.put("host", new SettingsConfiguration.Builder(supportedTaskTypes).setDescription("The name of the host address used for the {infer} task. You can find the host address at https://opensearch.console.aliyun.com/cn-shanghai/rag/api-key[ the API keys section] of the documentation.").setLabel("Host").setRequired(Boolean.valueOf(true)).setSensitive(Boolean.valueOf(false)).setUpdatable(Boolean.valueOf(false)).setType(SettingsConfigurationFieldType.STRING).build());
            configurationMap.put("http_schema", new SettingsConfiguration.Builder(supportedTaskTypes).setDescription("").setLabel("HTTP Schema").setRequired(Boolean.valueOf(false)).setSensitive(Boolean.valueOf(false)).setUpdatable(Boolean.valueOf(false)).setType(SettingsConfigurationFieldType.STRING).build());
            configurationMap.put("workspace", new SettingsConfiguration.Builder(supportedTaskTypes).setDescription("The name of the workspace used for the {infer} task.").setLabel("Workspace").setRequired(Boolean.valueOf(true)).setSensitive(Boolean.valueOf(false)).setUpdatable(Boolean.valueOf(false)).setType(SettingsConfigurationFieldType.STRING).build());
            configurationMap.putAll(DefaultSecretSettings.toSettingsConfigurationWithDescription("A valid API key for the AlibabaCloud AI Search API.", supportedTaskTypes));
            configurationMap.putAll(RateLimitSettings.toSettingsConfiguration(supportedTaskTypes));
            return new InferenceServiceConfiguration.Builder().setService(AlibabaCloudSearchService.NAME).setName(AlibabaCloudSearchService.SERVICE_NAME).setTaskTypes(supportedTaskTypes).setConfigurations(configurationMap).build();
        });

        public static InferenceServiceConfiguration get() {
            return (InferenceServiceConfiguration)configuration.getOrCompute();
        }
    }
}

