/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.exponentialhistogram;

import java.io.IOException;
import java.io.OutputStream;
import java.util.OptionalLong;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.exponentialhistogram.AbstractExponentialHistogram;
import org.elasticsearch.exponentialhistogram.BucketIterator;
import org.elasticsearch.exponentialhistogram.CompressedHistogramData;
import org.elasticsearch.exponentialhistogram.CopyableBucketIterator;
import org.elasticsearch.exponentialhistogram.ExponentialHistogram;
import org.elasticsearch.exponentialhistogram.ZeroBucket;

public class CompressedExponentialHistogram
extends AbstractExponentialHistogram {
    private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(CompressedExponentialHistogram.class);
    private double zeroThreshold;
    private long valueCount;
    private double sum;
    private double min;
    private double max;
    private ZeroBucket lazyZeroBucket;
    private final CompressedHistogramData encodedData = new CompressedHistogramData();
    private final Buckets positiveBuckets = new Buckets(true);
    private final Buckets negativeBuckets = new Buckets(false);

    @Override
    public int scale() {
        return this.encodedData.scale();
    }

    @Override
    public ZeroBucket zeroBucket() {
        if (this.lazyZeroBucket == null) {
            long zeroCount = this.valueCount - this.negativeBuckets.valueCount() - this.positiveBuckets.valueCount();
            this.lazyZeroBucket = ZeroBucket.create(this.zeroThreshold, zeroCount);
        }
        return this.lazyZeroBucket;
    }

    @Override
    public double sum() {
        return this.sum;
    }

    @Override
    public long valueCount() {
        return this.valueCount;
    }

    @Override
    public double min() {
        return this.min;
    }

    @Override
    public double max() {
        return this.max;
    }

    @Override
    public ExponentialHistogram.Buckets positiveBuckets() {
        return this.positiveBuckets;
    }

    @Override
    public ExponentialHistogram.Buckets negativeBuckets() {
        return this.negativeBuckets;
    }

    public void reset(double zeroThreshold, long valueCount, double sum, double min, double max, BytesRef encodedHistogramData) throws IOException {
        this.lazyZeroBucket = null;
        this.zeroThreshold = zeroThreshold;
        this.valueCount = valueCount;
        this.sum = sum;
        this.min = min;
        this.max = max;
        this.encodedData.decode(encodedHistogramData);
        this.negativeBuckets.resetCachedData();
        this.positiveBuckets.resetCachedData();
    }

    public static void writeHistogramBytes(OutputStream output, int scale, BucketIterator negativeBuckets, BucketIterator positiveBuckets) throws IOException {
        CompressedHistogramData.write(output, scale, negativeBuckets, positiveBuckets);
    }

    public long ramBytesUsed() {
        return SHALLOW_SIZE + ZeroBucket.SHALLOW_SIZE + 2L * Buckets.SHALLOW_SIZE + CompressedHistogramData.SHALLOW_SIZE;
    }

    private final class Buckets
    implements ExponentialHistogram.Buckets {
        private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOf(Buckets.class);
        private final boolean isForPositiveBuckets;
        private long cachedValueCount;
        private long cachedMaxIndex;

        private Buckets(boolean isForPositiveBuckets) {
            this.isForPositiveBuckets = isForPositiveBuckets;
            this.resetCachedData();
        }

        private void resetCachedData() {
            this.cachedValueCount = -1L;
            this.cachedMaxIndex = Long.MIN_VALUE;
        }

        private void computeCachedDataIfRequired() {
            if (this.cachedValueCount == -1L) {
                this.cachedValueCount = 0L;
                CopyableBucketIterator it = this.iterator();
                while (it.hasNext()) {
                    this.cachedMaxIndex = it.peekIndex();
                    this.cachedValueCount += it.peekCount();
                    it.advance();
                }
            }
        }

        @Override
        public CopyableBucketIterator iterator() {
            if (this.isForPositiveBuckets) {
                return new CompressedBucketsIterator(CompressedExponentialHistogram.this.encodedData.positiveBucketsDecoder());
            }
            return new CompressedBucketsIterator(CompressedExponentialHistogram.this.encodedData.negativeBucketsDecoder());
        }

        @Override
        public OptionalLong maxBucketIndex() {
            this.computeCachedDataIfRequired();
            return this.cachedValueCount > 0L ? OptionalLong.of(this.cachedMaxIndex) : OptionalLong.empty();
        }

        @Override
        public long valueCount() {
            this.computeCachedDataIfRequired();
            return this.cachedValueCount;
        }

        private class CompressedBucketsIterator
        implements CopyableBucketIterator {
            private final CompressedHistogramData.BucketsDecoder decoder;

            CompressedBucketsIterator(CompressedHistogramData.BucketsDecoder delegate) {
                this.decoder = delegate;
            }

            @Override
            public CopyableBucketIterator copy() {
                return new CompressedBucketsIterator(this.decoder.copy());
            }

            @Override
            public final boolean hasNext() {
                return this.decoder.hasNext();
            }

            @Override
            public final long peekCount() {
                return this.decoder.peekCount();
            }

            @Override
            public final long peekIndex() {
                return this.decoder.peekIndex();
            }

            @Override
            public int scale() {
                return CompressedExponentialHistogram.this.scale();
            }

            @Override
            public final void advance() {
                this.decoder.advance();
            }
        }
    }
}

