/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm.action;

import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ilm.action.ILMActions;
import org.elasticsearch.xpack.core.ilm.action.PutLifecycleRequest;
import org.elasticsearch.xpack.ilm.PutLifecycleMetadataService;

public class TransportPutLifecycleAction
extends TransportMasterNodeAction<PutLifecycleRequest, AcknowledgedResponse> {
    private final PutLifecycleMetadataService putLifecycleMetadataService;

    @Inject
    public TransportPutLifecycleAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, PutLifecycleMetadataService putLifecycleMetadataService) {
        super(ILMActions.PUT.name(), transportService, clusterService, threadPool, actionFilters, PutLifecycleRequest::new, AcknowledgedResponse::readFrom, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.putLifecycleMetadataService = putLifecycleMetadataService;
    }

    protected void masterOperation(Task task, PutLifecycleRequest request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        this.putLifecycleMetadataService.addLifecycle(request, state, listener);
    }

    protected ClusterBlockException checkBlock(PutLifecycleRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    public Optional<String> reservedStateHandlerName() {
        return Optional.of("ilm");
    }

    public Set<String> modifiedKeys(PutLifecycleRequest request) {
        return Set.of(request.getPolicy().getName());
    }
}

