/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.join.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.plain.SortedSetOrdinalsIndexFieldData;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.IndexType;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.join.mapper.Joiner;
import org.elasticsearch.join.mapper.ParentIdFieldMapper;
import org.elasticsearch.join.mapper.Relations;
import org.elasticsearch.script.field.DelegateDocValuesField;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public final class ParentJoinFieldMapper
extends FieldMapper {
    private static final DeprecationLogger DEPRECATION_LOGGER = DeprecationLogger.getLogger(ParentJoinFieldMapper.class);
    public static final String NAME = "join";
    public static final String CONTENT_TYPE = "join";
    public static final FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> {
        ParentJoinFieldMapper.checkIndexCompatibility(c.getIndexSettings(), n);
        return new Builder((String)n);
    });
    private final Map<String, ParentIdFieldMapper> parentIdFields;
    private final boolean eagerGlobalOrdinals;
    private final List<Relations> relations;

    private static void checkIndexCompatibility(IndexSettings settings, String name) {
        String indexName = settings.getIndex().getName();
        if (settings.getIndexMetadata().isRoutingPartitionedIndex()) {
            throw new IllegalStateException("cannot create join field [" + name + "] for the partitioned index [" + indexName + "]");
        }
        if (!settings.getIndexMetadata().getRoutingPaths().isEmpty()) {
            throw new IllegalStateException("cannot create join field [" + name + "] for the index [" + indexName + "] with routing_path");
        }
    }

    private static void checkObjectOrNested(MapperBuilderContext context, String name) {
        String fullName = context.buildFullName(name);
        if (!fullName.equals(name)) {
            throw new IllegalArgumentException("join field [" + fullName + "] cannot be added inside an object or in a multi-field");
        }
    }

    private static ParentJoinFieldMapper toType(FieldMapper in) {
        return (ParentJoinFieldMapper)in;
    }

    private static boolean checkRelationsConflicts(List<Relations> previous, List<Relations> current, FieldMapper.Conflicts conflicts) {
        Joiner pj = new Joiner("f", previous);
        Joiner cj = new Joiner("f", current);
        return pj.canMerge(cj, s -> conflicts.addConflict("relations", s));
    }

    protected ParentJoinFieldMapper(String simpleName, MappedFieldType mappedFieldType, Map<String, ParentIdFieldMapper> parentIdFields, boolean eagerGlobalOrdinals, List<Relations> relations) {
        super(simpleName, mappedFieldType, FieldMapper.BuilderParams.empty());
        this.parentIdFields = parentIdFields;
        this.eagerGlobalOrdinals = eagerGlobalOrdinals;
        this.relations = relations;
    }

    public Map<String, NamedAnalyzer> indexAnalyzers() {
        return Map.of(this.mappedFieldType.name(), Lucene.KEYWORD_ANALYZER);
    }

    protected String contentType() {
        return "join";
    }

    public JoinFieldType fieldType() {
        return (JoinFieldType)super.fieldType();
    }

    public Iterator<Mapper> iterator() {
        ArrayList<ParentIdFieldMapper> mappers = new ArrayList<ParentIdFieldMapper>(this.parentIdFields.values());
        return mappers.iterator();
    }

    protected void parseCreateField(DocumentParserContext context) {
        throw new UnsupportedOperationException("parsing is implemented in parse(), this method should NEVER be called");
    }

    protected boolean supportsParsingObject() {
        return true;
    }

    public void parse(DocumentParserContext context) throws IOException {
        String fieldName;
        context.path().add(this.leafName());
        XContentParser.Token token = context.parser().currentToken();
        String name = null;
        String parent = null;
        if (token == XContentParser.Token.START_OBJECT) {
            String currentFieldName = null;
            while ((token = context.parser().nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = context.parser().currentName();
                    continue;
                }
                if (token == XContentParser.Token.VALUE_STRING) {
                    if ("name".equals(currentFieldName)) {
                        name = context.parser().text();
                        continue;
                    }
                    if ("parent".equals(currentFieldName)) {
                        parent = context.parser().text();
                        continue;
                    }
                    throw new IllegalArgumentException("unknown field name [" + currentFieldName + "] in join field [" + this.fullPath() + "]");
                }
                if (token != XContentParser.Token.VALUE_NUMBER) continue;
                if ("parent".equals(currentFieldName)) {
                    parent = context.parser().numberValue().toString();
                    continue;
                }
                throw new IllegalArgumentException("unknown field name [" + currentFieldName + "] in join field [" + this.fullPath() + "]");
            }
        } else if (token == XContentParser.Token.VALUE_STRING) {
            name = context.parser().text();
            parent = null;
        } else {
            throw new IllegalStateException("[" + this.fullPath() + "] expected START_OBJECT or VALUE_STRING but was: " + String.valueOf(token));
        }
        if (name == null) {
            throw new IllegalArgumentException("null join name in field [" + this.fullPath() + "]");
        }
        if (!this.fieldType().joiner.knownRelation(name)) {
            throw new IllegalArgumentException("unknown join name [" + name + "] for field [" + this.fullPath() + "]");
        }
        if (this.fieldType().joiner.childTypeExists(name)) {
            if (parent == null) {
                throw new IllegalArgumentException("[parent] is missing for join field [" + this.fullPath() + "]");
            }
            if (context.routing() == null) {
                throw new IllegalArgumentException("[routing] is missing for join field [" + this.fullPath() + "]");
            }
            fieldName = this.fieldType().joiner.parentJoinField(name);
            this.parentIdFields.get(fieldName).indexValue(context, parent);
        }
        if (this.fieldType().joiner.parentTypeExists(name)) {
            fieldName = this.fieldType().joiner.childJoinField(name);
            this.parentIdFields.get(fieldName).indexValue(context, context.id());
        }
        BytesRef binaryValue = new BytesRef((CharSequence)name);
        StringField field = new StringField(this.fieldType().name(), binaryValue, Field.Store.NO);
        context.doc().add((IndexableField)field);
        context.doc().add((IndexableField)new SortedDocValuesField(this.fieldType().name(), binaryValue));
        context.path().remove();
    }

    protected void doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("type", this.contentType());
        builder.field("eager_global_ordinals", this.eagerGlobalOrdinals);
        builder.startObject("relations");
        for (Relations relation : this.relations) {
            if (relation.children().size() == 1) {
                builder.field(relation.parent(), relation.children().iterator().next());
                continue;
            }
            builder.field(relation.parent(), relation.children());
        }
        builder.endObject();
    }

    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.leafName()).init(this);
    }

    protected void doValidate(MappingLookup mappingLookup) {
        List<String> joinFields = mappingLookup.getMatchingFieldNames("*").stream().map(arg_0 -> ((MappingLookup)mappingLookup).getFieldType(arg_0)).filter(ft -> ft instanceof JoinFieldType).map(MappedFieldType::name).toList();
        if (joinFields.size() > 1) {
            throw new IllegalArgumentException("Only one [parent-join] field can be defined per index, got " + String.valueOf(joinFields));
        }
    }

    public static final class JoinFieldType
    extends StringFieldType {
        private final Joiner joiner;

        private JoinFieldType(String name, Joiner joiner, Map<String, String> meta) {
            super(name, IndexType.terms((boolean)true, (boolean)true), false, TextSearchInfo.SIMPLE_MATCH_ONLY, meta);
            this.joiner = joiner;
        }

        Joiner getJoiner() {
            return this.joiner;
        }

        public String typeName() {
            return "join";
        }

        public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
            return new SortedSetOrdinalsIndexFieldData.Builder(this.name(), (ValuesSourceType)CoreValuesSourceType.KEYWORD, (dv, n) -> new DelegateDocValuesField((ScriptDocValues)new ScriptDocValues.Strings((ScriptDocValues.Supplier)new ScriptDocValues.StringsSupplier(FieldData.toString((SortedSetDocValues)dv))), n));
        }

        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            return SourceValueFetcher.identity((String)this.name(), (SearchExecutionContext)context, (String)format);
        }

        public Object valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            BytesRef binaryValue = (BytesRef)value;
            return binaryValue.utf8ToString();
        }
    }

    public static class Builder
    extends FieldMapper.Builder {
        final FieldMapper.Parameter<Boolean> eagerGlobalOrdinals = FieldMapper.Parameter.boolParam((String)"eager_global_ordinals", (boolean)true, m -> ParentJoinFieldMapper.toType((FieldMapper)m).eagerGlobalOrdinals, (boolean)true);
        final FieldMapper.Parameter<List<Relations>> relations = new FieldMapper.Parameter("relations", true, Collections::emptyList, (n, c, o) -> Relations.parse(o), m -> ParentJoinFieldMapper.toType((FieldMapper)m).relations, XContentBuilder::field, Objects::toString).setMergeValidator(ParentJoinFieldMapper::checkRelationsConflicts);
        final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();

        public Builder(String name) {
            super(name);
        }

        public Builder addRelation(String parent, Set<String> children) {
            this.relations.setValue(Collections.singletonList(new Relations(parent, children)));
            return this;
        }

        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.eagerGlobalOrdinals, this.relations, this.meta};
        }

        public ParentJoinFieldMapper build(MapperBuilderContext context) {
            if (this.multiFieldsBuilder.hasMultiFields()) {
                DEPRECATION_LOGGER.warn(DeprecationCategory.MAPPINGS, "join_multifields", "Adding multifields to [join] mappers has no effect and will be forbidden in future", new Object[0]);
            }
            ParentJoinFieldMapper.checkObjectOrNested(context, this.leafName());
            HashMap parentIdFields = new HashMap();
            ((List)this.relations.get()).stream().map(relation -> new ParentIdFieldMapper(this.leafName() + "#" + relation.parent(), (Boolean)this.eagerGlobalOrdinals.get())).forEach(mapper -> parentIdFields.put(mapper.fullPath(), mapper));
            Joiner joiner = new Joiner(this.leafName(), (List)this.relations.get());
            return new ParentJoinFieldMapper(this.leafName(), (MappedFieldType)new JoinFieldType(context.buildFullName(this.leafName()), joiner, (Map)this.meta.get()), Collections.unmodifiableMap(parentIdFields), (Boolean)this.eagerGlobalOrdinals.get(), (List)this.relations.get());
        }
    }
}

