/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2InstanceConnectEndpoint;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.InstanceConnectEndpointSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeInstanceConnectEndpointsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeInstanceConnectEndpointsResponse> {
    private static final SdkField<List<Ec2InstanceConnectEndpoint>> INSTANCE_CONNECT_ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceConnectEndpoints").getter(DescribeInstanceConnectEndpointsResponse.getter(DescribeInstanceConnectEndpointsResponse::instanceConnectEndpoints)).setter(DescribeInstanceConnectEndpointsResponse.setter(Builder::instanceConnectEndpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceConnectEndpointSet").unmarshallLocationName("instanceConnectEndpointSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Ec2InstanceConnectEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeInstanceConnectEndpointsResponse.getter(DescribeInstanceConnectEndpointsResponse::nextToken)).setter(DescribeInstanceConnectEndpointsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_CONNECT_ENDPOINTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeInstanceConnectEndpointsResponse.memberNameToFieldInitializer();
    private final List<Ec2InstanceConnectEndpoint> instanceConnectEndpoints;
    private final String nextToken;

    private DescribeInstanceConnectEndpointsResponse(BuilderImpl builder) {
        super(builder);
        this.instanceConnectEndpoints = builder.instanceConnectEndpoints;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasInstanceConnectEndpoints() {
        return this.instanceConnectEndpoints != null && !(this.instanceConnectEndpoints instanceof SdkAutoConstructList);
    }

    public final List<Ec2InstanceConnectEndpoint> instanceConnectEndpoints() {
        return this.instanceConnectEndpoints;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceConnectEndpoints() ? this.instanceConnectEndpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstanceConnectEndpointsResponse)) {
            return false;
        }
        DescribeInstanceConnectEndpointsResponse other = (DescribeInstanceConnectEndpointsResponse)((Object)obj);
        return this.hasInstanceConnectEndpoints() == other.hasInstanceConnectEndpoints() && Objects.equals(this.instanceConnectEndpoints(), other.instanceConnectEndpoints()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeInstanceConnectEndpointsResponse").add("InstanceConnectEndpoints", this.hasInstanceConnectEndpoints() ? this.instanceConnectEndpoints() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceConnectEndpoints": {
                return Optional.ofNullable(clazz.cast(this.instanceConnectEndpoints()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InstanceConnectEndpointSet", INSTANCE_CONNECT_ENDPOINTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeInstanceConnectEndpointsResponse, T> g) {
        return obj -> g.apply((DescribeInstanceConnectEndpointsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<Ec2InstanceConnectEndpoint> instanceConnectEndpoints = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstanceConnectEndpointsResponse model) {
            super(model);
            this.instanceConnectEndpoints(model.instanceConnectEndpoints);
            this.nextToken(model.nextToken);
        }

        public final List<Ec2InstanceConnectEndpoint.Builder> getInstanceConnectEndpoints() {
            List<Ec2InstanceConnectEndpoint.Builder> result = InstanceConnectEndpointSetCopier.copyToBuilder(this.instanceConnectEndpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceConnectEndpoints(Collection<Ec2InstanceConnectEndpoint.BuilderImpl> instanceConnectEndpoints) {
            this.instanceConnectEndpoints = InstanceConnectEndpointSetCopier.copyFromBuilder(instanceConnectEndpoints);
        }

        @Override
        public final Builder instanceConnectEndpoints(Collection<Ec2InstanceConnectEndpoint> instanceConnectEndpoints) {
            this.instanceConnectEndpoints = InstanceConnectEndpointSetCopier.copy(instanceConnectEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceConnectEndpoints(Ec2InstanceConnectEndpoint ... instanceConnectEndpoints) {
            this.instanceConnectEndpoints(Arrays.asList(instanceConnectEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceConnectEndpoints(Consumer<Ec2InstanceConnectEndpoint.Builder> ... instanceConnectEndpoints) {
            this.instanceConnectEndpoints(Stream.of(instanceConnectEndpoints).map(c -> (Ec2InstanceConnectEndpoint)((Ec2InstanceConnectEndpoint.Builder)Ec2InstanceConnectEndpoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeInstanceConnectEndpointsResponse build() {
            return new DescribeInstanceConnectEndpointsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeInstanceConnectEndpointsResponse> {
        public Builder instanceConnectEndpoints(Collection<Ec2InstanceConnectEndpoint> var1);

        public Builder instanceConnectEndpoints(Ec2InstanceConnectEndpoint ... var1);

        public Builder instanceConnectEndpoints(Consumer<Ec2InstanceConnectEndpoint.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

