/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugin.analysis.nori;

import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ko.KoreanPartOfSpeechStopFilter;
import org.apache.lucene.analysis.ko.POS;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.analysis.Analysis;

public class NoriPartOfSpeechStopFilterFactory
extends AbstractTokenFilterFactory {
    private final Set<POS.Tag> stopTags;

    public NoriPartOfSpeechStopFilterFactory(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(name);
        List tagList = Analysis.getWordList((Environment)env, (Settings)settings, (String)"stoptags");
        this.stopTags = tagList != null ? NoriPartOfSpeechStopFilterFactory.resolvePOSList(tagList) : KoreanPartOfSpeechStopFilter.DEFAULT_STOP_TAGS;
    }

    public TokenStream create(TokenStream tokenStream) {
        return new KoreanPartOfSpeechStopFilter(tokenStream, this.stopTags);
    }

    static Set<POS.Tag> resolvePOSList(List<String> tagList) {
        EnumSet<POS.Tag> stopTags = EnumSet.noneOf(POS.Tag.class);
        for (String tag : tagList) {
            stopTags.add(POS.resolveTag((String)tag));
        }
        return stopTags;
    }
}

