/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.reflect;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.services.reflect.DatabaseClasses;
import org.apache.derby.impl.services.reflect.LoadedGeneratedClass;
import org.apache.derby.impl.services.reflect.ReflectGeneratedClass;
import org.apache.derby.impl.services.reflect.ReflectLoaderJava2;

public class ReflectClassesJava2
extends DatabaseClasses
implements PrivilegedAction<Object> {
    private HashMap<String, ReflectGeneratedClass> preCompiled;
    private int action = -1;

    @Override
    synchronized LoadedGeneratedClass loadGeneratedClassFromData(String fullyQualifiedName, ByteArray classDump) {
        if (classDump == null || classDump.getArray() == null) {
            if (this.preCompiled == null) {
                this.preCompiled = new HashMap();
            } else {
                ReflectGeneratedClass gc = this.preCompiled.get(fullyQualifiedName);
                if (gc != null) {
                    return gc;
                }
            }
            try {
                Class<?> jvmClass = Class.forName(fullyQualifiedName);
                ReflectGeneratedClass gc = new ReflectGeneratedClass(this, jvmClass);
                this.preCompiled.put(fullyQualifiedName, gc);
                return gc;
            }
            catch (ClassNotFoundException cnfe) {
                throw new NoClassDefFoundError(cnfe.toString());
            }
        }
        int lastDot = fullyQualifiedName.lastIndexOf(".");
        String actualPackage = lastDot < 0 ? "" : fullyQualifiedName.substring(0, lastDot + 1);
        if (!"org.apache.derby.exe.".equals(actualPackage)) {
            throw new IllegalArgumentException(fullyQualifiedName);
        }
        this.action = 1;
        return ((ReflectLoaderJava2)AccessController.doPrivileged(this)).loadGeneratedClass(fullyQualifiedName, classDump);
    }

    @Override
    public final Object run() {
        try {
            switch (this.action) {
                case 1: {
                    ReflectLoaderJava2 reflectLoaderJava2 = new ReflectLoaderJava2(this.getClass().getClassLoader(), this);
                    return reflectLoaderJava2;
                }
                case 2: {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    return classLoader;
                }
            }
            Object var1_3 = null;
            return var1_3;
        }
        finally {
            this.action = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Class loadClassNotInDatabaseJar(String name) throws ClassNotFoundException {
        Class<?> foundClass = null;
        try {
            ClassLoader cl;
            ReflectClassesJava2 reflectClassesJava2 = this;
            synchronized (reflectClassesJava2) {
                this.action = 2;
                cl = (ClassLoader)AccessController.doPrivileged(this);
            }
            foundClass = cl != null ? cl.loadClass(name) : Class.forName(name);
        }
        catch (ClassNotFoundException cnfe) {
            foundClass = Class.forName(name);
        }
        return foundClass;
    }
}

