/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm.action;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.local.LocalClusterStateRequest;
import org.elasticsearch.cluster.metadata.ItemUsage;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicy;

public class GetLifecycleAction
extends ActionType<Response> {
    public static final GetLifecycleAction INSTANCE = new GetLifecycleAction();
    public static final String NAME = "cluster:admin/ilm/get";

    protected GetLifecycleAction() {
        super(NAME);
    }

    public static class LifecyclePolicyResponseItem
    implements Writeable {
        private final LifecyclePolicy lifecyclePolicy;
        private final long version;
        private final String modifiedDate;
        private final ItemUsage usage;

        public LifecyclePolicyResponseItem(LifecyclePolicy lifecyclePolicy, long version, String modifiedDate, ItemUsage usage) {
            this.lifecyclePolicy = lifecyclePolicy;
            this.version = version;
            this.modifiedDate = modifiedDate;
            this.usage = usage;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.lifecyclePolicy.writeTo(out);
            out.writeVLong(this.version);
            out.writeString(this.modifiedDate);
            this.usage.writeTo(out);
        }

        public LifecyclePolicy getLifecyclePolicy() {
            return this.lifecyclePolicy;
        }

        public long getVersion() {
            return this.version;
        }

        public String getModifiedDate() {
            return this.modifiedDate;
        }

        public ItemUsage getUsage() {
            return this.usage;
        }

        public int hashCode() {
            return Objects.hash(this.lifecyclePolicy, this.version, this.modifiedDate, this.usage);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            LifecyclePolicyResponseItem other = (LifecyclePolicyResponseItem)obj;
            return Objects.equals(this.lifecyclePolicy, other.lifecyclePolicy) && Objects.equals(this.version, other.version) && Objects.equals(this.modifiedDate, other.modifiedDate) && Objects.equals(this.usage, other.usage);
        }
    }

    public static class Request
    extends LocalClusterStateRequest {
        private final String[] policyNames;

        public Request(TimeValue masterNodeTimeout, String ... policyNames) {
            super(masterNodeTimeout);
            if (policyNames == null) {
                throw new IllegalArgumentException("ids cannot be null");
            }
            this.policyNames = policyNames;
        }

        public Request(StreamInput in) throws IOException {
            super(in, false);
            in.readTimeValue();
            this.policyNames = in.readStringArray();
        }

        @Override
        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new CancellableTask(id, type, action, "get-lifecycle-task", parentTaskId, headers);
        }

        public String[] getPolicyNames() {
            return this.policyNames;
        }

        public int hashCode() {
            return Arrays.hashCode(this.policyNames);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            Request other = (Request)obj;
            return Arrays.equals(this.policyNames, other.policyNames);
        }
    }

    public static class Response
    extends ActionResponse
    implements ChunkedToXContentObject {
        private final List<LifecyclePolicyResponseItem> policies;

        public Response(List<LifecyclePolicyResponseItem> policies) {
            this.policies = policies;
        }

        public List<LifecyclePolicyResponseItem> getPolicies() {
            return this.policies;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeCollection(this.policies);
        }

        public int hashCode() {
            return Objects.hash(this.policies);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            Response other = (Response)obj;
            return Objects.equals(this.policies, other.policies);
        }

        public String toString() {
            return Strings.toString(this, true, true);
        }

        public Iterator<ToXContent> toXContentChunked(ToXContent.Params outerParams) {
            return Iterators.concat(Iterators.single((builder, params) -> builder.startObject()), Iterators.map(this.policies.iterator(), policy -> (b, p) -> {
                b.startObject(policy.getLifecyclePolicy().getName());
                b.field("version", policy.getVersion());
                b.field("modified_date", policy.getModifiedDate());
                b.field("policy", policy.getLifecyclePolicy());
                b.field("in_use_by", policy.getUsage());
                b.endObject();
                return b;
            }), Iterators.single((b, p) -> b.endObject()));
        }
    }
}

