/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.runtime;

import java.util.Objects;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.script.AbstractLongFieldScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.runtime.AbstractLongScriptFieldQuery;

public class LongScriptFieldTermQuery
extends AbstractLongScriptFieldQuery {
    private final long term;

    public LongScriptFieldTermQuery(Script script, Function<LeafReaderContext, AbstractLongFieldScript> leafFactory, String fieldName, long term) {
        super(script, leafFactory, fieldName);
        this.term = term;
    }

    @Override
    protected boolean matches(long[] values, int count) {
        for (int i = 0; i < count; ++i) {
            if (this.term != values[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public final String toString(String field) {
        if (this.fieldName().contentEquals(field)) {
            return Long.toString(this.term);
        }
        return this.fieldName() + ":" + this.term;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.term);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        LongScriptFieldTermQuery other = (LongScriptFieldTermQuery)obj;
        return this.term == other.term;
    }

    long term() {
        return this.term;
    }
}

