/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiTerms;
import org.apache.lucene.index.ReaderSlice;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.CompiledAutomaton;

class SortedSetDocValuesTerms
extends Terms {
    private final SortedSetDocValues values;

    public static Terms getTerms(IndexReader r, String field) throws IOException {
        List<LeafReaderContext> leaves = r.leaves();
        if (leaves.size() == 1) {
            SortedSetDocValues sortedSetDocValues = leaves.get(0).reader().getSortedSetDocValues(field);
            if (sortedSetDocValues == null) {
                return null;
            }
            return new SortedSetDocValuesTerms(sortedSetDocValues);
        }
        ArrayList<SortedSetDocValuesTerms> termsPerLeaf = new ArrayList<SortedSetDocValuesTerms>(leaves.size());
        ArrayList<ReaderSlice> slicePerLeaf = new ArrayList<ReaderSlice>(leaves.size());
        for (int leafIdx = 0; leafIdx < leaves.size(); ++leafIdx) {
            LeafReaderContext ctx = leaves.get(leafIdx);
            SortedSetDocValues sortedSetDocValues = ctx.reader().getSortedSetDocValues(field);
            if (sortedSetDocValues == null) continue;
            termsPerLeaf.add(new SortedSetDocValuesTerms(sortedSetDocValues));
            slicePerLeaf.add(new ReaderSlice(ctx.docBase, r.maxDoc(), leafIdx));
        }
        if (termsPerLeaf.isEmpty()) {
            return null;
        }
        return new MultiTerms(termsPerLeaf.toArray(EMPTY_ARRAY), slicePerLeaf.toArray(ReaderSlice.EMPTY_ARRAY));
    }

    SortedSetDocValuesTerms(SortedSetDocValues values) {
        this.values = values;
    }

    @Override
    public TermsEnum iterator() throws IOException {
        return this.values.termsEnum();
    }

    @Override
    public TermsEnum intersect(CompiledAutomaton compiled, BytesRef startTerm) throws IOException {
        if (startTerm == null) {
            return this.values.intersect(compiled);
        }
        return super.intersect(compiled, startTerm);
    }

    @Override
    public long size() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getSumTotalTermFreq() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getSumDocFreq() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getDocCount() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasFreqs() {
        return false;
    }

    @Override
    public boolean hasOffsets() {
        return false;
    }

    @Override
    public boolean hasPositions() {
        return false;
    }

    @Override
    public boolean hasPayloads() {
        return false;
    }
}

