/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.common.util.AbstractBigArray;
import org.elasticsearch.common.util.BigArrays;

abstract class AbstractBigByteArray
extends AbstractBigArray {
    protected static final byte[] ZERO_PAGE = new byte[16384];
    protected byte[][] pages;

    protected AbstractBigByteArray(int pageSize, BigArrays bigArrays, boolean clearOnResize, long size) {
        super(pageSize, bigArrays, clearOnResize);
        this.size = size;
        this.pages = new byte[this.numPages(size)][];
        Arrays.fill((Object[])this.pages, ZERO_PAGE);
        assert (AbstractBigByteArray.assertZeroPageClean());
    }

    private static boolean assertZeroPageClean() {
        for (byte b : ZERO_PAGE) {
            assert (b == 0) : b;
        }
        return true;
    }

    @Override
    public void resize(long newSize) {
        int i;
        int numPages = this.numPages(newSize);
        if (numPages > this.pages.length) {
            this.pages = (byte[][])Arrays.copyOf(this.pages, ArrayUtil.oversize(numPages, RamUsageEstimator.NUM_BYTES_OBJECT_REF));
        }
        for (i = numPages - 1; i >= 0 && this.pages[i] == null; --i) {
            this.pages[i] = ZERO_PAGE;
        }
        for (i = numPages; i < this.pages.length && this.pages[i] != null; ++i) {
            assert (this.pages[i] != ZERO_PAGE);
            this.pages[i] = null;
            this.releasePage(i);
        }
        this.size = newSize;
    }

    private byte[] newBytePage(int page) {
        if (this.recycler != null) {
            Recycler.V<byte[]> v = this.recycler.bytePage(this.clearOnResize);
            return this.registerNewPage(v, page, 16384);
        }
        return new byte[16384];
    }

    protected static void fillBySelfCopy(byte[] page, int fromBytes, int toBytes, int initialCopyBytes) {
        int copyBytesLength;
        for (int pos = fromBytes + initialCopyBytes; pos < toBytes; pos += copyBytesLength) {
            int sourceBytesLength = pos - fromBytes;
            copyBytesLength = Math.min(sourceBytesLength, toBytes - pos);
            System.arraycopy(page, fromBytes, page, pos, copyBytesLength);
        }
    }

    protected void set(long index, byte[] buf, int offset, int len, int shift) {
        assert (index + (long)len <= this.size());
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        if (indexInPage + len <= this.pageSize()) {
            System.arraycopy(buf, offset << shift, this.getPageForWriting(pageIndex), indexInPage << shift, len << shift);
        } else {
            int copyLen = this.pageSize() - indexInPage;
            System.arraycopy(buf, offset << shift, this.getPageForWriting(pageIndex), indexInPage, copyLen << shift);
            do {
                copyLen = Math.min(len -= copyLen, this.pageSize());
                System.arraycopy(buf, (offset += copyLen) << shift, this.getPageForWriting(++pageIndex), 0, copyLen << shift);
            } while (len > copyLen);
        }
    }

    protected byte[] getPageForWriting(int pageIndex) {
        byte[] foundPage = this.pages[pageIndex];
        if (foundPage == ZERO_PAGE) {
            foundPage = this.newBytePage(pageIndex);
            this.pages[pageIndex] = foundPage;
        }
        return foundPage;
    }

    protected void readPages(StreamInput in) throws IOException {
        int len;
        int remainedBytes = in.readVInt();
        for (int i = 0; i < this.pages.length && remainedBytes > 0; remainedBytes -= len, ++i) {
            len = Math.min(remainedBytes, this.pages[0].length);
            in.readBytes(this.getPageForWriting(i), 0, len);
        }
    }
}

