/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public record EstimatedHeapUsage(String nodeId, long totalBytes, long estimatedUsageBytes) implements Writeable
{
    public EstimatedHeapUsage {
        assert (totalBytes >= 0L);
        assert (estimatedUsageBytes >= 0L);
    }

    public EstimatedHeapUsage(StreamInput in) throws IOException {
        this(in.readString(), in.readVLong(), in.readVLong());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.nodeId);
        out.writeVLong(this.totalBytes);
        out.writeVLong(this.estimatedUsageBytes);
    }

    public long estimatedFreeBytes() {
        return this.totalBytes - this.estimatedUsageBytes;
    }

    public double estimatedFreeBytesAsPercentage() {
        return 100.0 - this.estimatedUsageAsPercentage();
    }

    public double estimatedUsageAsPercentage() {
        return 100.0 * this.estimatedUsageAsRatio();
    }

    public double estimatedUsageAsRatio() {
        return (double)this.estimatedUsageBytes / (double)this.totalBytes;
    }
}

