/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.io.IOException;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.common.xcontent.XContentElasticsearchExtension;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.json.JsonXContent;

public class FailureStoreDocumentConverter {
    private static final int STACKTRACE_PRINT_DEPTH = 2;
    private static final Set<String> INGEST_EXCEPTION_HEADERS = Set.of("pipeline_origin", "processor_tag", "processor_type");

    public IndexRequest transformFailedRequest(IndexRequest source, Exception exception, String targetIndexName) throws IOException {
        return this.transformFailedRequest(source, exception, targetIndexName, System::currentTimeMillis);
    }

    public IndexRequest transformFailedRequest(IndexRequest source, Exception exception, String targetIndexName, Supplier<Long> timeSupplier) throws IOException {
        return ((IndexRequest)new IndexRequest().index(targetIndexName)).source(FailureStoreDocumentConverter.createSource(source, exception, timeSupplier)).opType(DocWriteRequest.OpType.CREATE).setWriteToFailureStore(true);
    }

    private static XContentBuilder createSource(IndexRequest source, Exception exception, Supplier<Long> timeSupplier) throws IOException {
        Objects.requireNonNull(source, "source must not be null");
        Objects.requireNonNull(exception, "exception must not be null");
        Objects.requireNonNull(timeSupplier, "timeSupplier must not be null");
        Throwable unwrapped = ExceptionsHelper.unwrapCause(exception);
        XContentBuilder builder = JsonXContent.contentBuilder();
        builder.startObject();
        builder.field("@timestamp", XContentElasticsearchExtension.DEFAULT_FORMATTER.format(Instant.ofEpochMilli(timeSupplier.get())));
        builder.startObject("document");
        if (source.id() != null) {
            builder.field("id", source.id());
        }
        if (source.routing() != null) {
            builder.field("routing", source.routing());
        }
        if (source.index() != null) {
            builder.field("index", source.index());
        }
        builder.startObject("source");
        builder.mapContents(source.sourceAsMap());
        builder.endObject();
        builder.endObject();
        builder.startObject("error");
        builder.field("type", ElasticsearchException.getExceptionName(unwrapped));
        builder.field("message", unwrapped.getMessage());
        builder.field("stack_trace", ExceptionsHelper.limitedStackTrace(unwrapped, 2));
        ElasticsearchException ingestException = ExceptionsHelper.unwrapCausesAndSuppressed(exception, t -> {
            ElasticsearchException e;
            return t instanceof ElasticsearchException && Sets.haveNonEmptyIntersection((e = (ElasticsearchException)t).getBodyHeaderKeys(), INGEST_EXCEPTION_HEADERS);
        }).orElse(null);
        if (ingestException != null) {
            if (ingestException.getBodyHeaderKeys().contains("pipeline_origin")) {
                List<String> pipelineOrigin = ingestException.getBodyHeader("pipeline_origin");
                Collections.reverse(pipelineOrigin);
                if (!pipelineOrigin.isEmpty()) {
                    builder.field("pipeline_trace", (Collection<String>)pipelineOrigin);
                    builder.field("pipeline", pipelineOrigin.get(pipelineOrigin.size() - 1));
                }
            }
            if (ingestException.getBodyHeaderKeys().contains("processor_tag")) {
                builder.field("processor_tag", ingestException.getBodyHeader("processor_tag").get(0));
            }
            if (ingestException.getBodyHeaderKeys().contains("processor_type")) {
                builder.field("processor_type", ingestException.getBodyHeader("processor_type").get(0));
            }
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }
}

