/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.searchablesnapshots;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.XPackFeatureUsage;

public class SearchableSnapshotFeatureSetUsage
extends XPackFeatureUsage {
    private final int numberOfSearchableSnapshotIndices;
    private final int numberOfFullCopySearchableSnapshotIndices;
    private final int numberOfSharedCacheSearchableSnapshotIndices;

    public SearchableSnapshotFeatureSetUsage(StreamInput input) throws IOException {
        super(input);
        this.numberOfSearchableSnapshotIndices = input.readVInt();
        this.numberOfFullCopySearchableSnapshotIndices = input.readVInt();
        this.numberOfSharedCacheSearchableSnapshotIndices = input.readVInt();
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersion.zero();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.numberOfSearchableSnapshotIndices);
        out.writeVInt(this.numberOfFullCopySearchableSnapshotIndices);
        out.writeVInt(this.numberOfSharedCacheSearchableSnapshotIndices);
    }

    public SearchableSnapshotFeatureSetUsage(boolean available, int numberOfFullCopySearchableSnapshotIndices, int numberOfSharedCacheSearchableSnapshotIndices) {
        super("searchable_snapshots", available, true);
        this.numberOfSearchableSnapshotIndices = numberOfFullCopySearchableSnapshotIndices + numberOfSharedCacheSearchableSnapshotIndices;
        this.numberOfFullCopySearchableSnapshotIndices = numberOfFullCopySearchableSnapshotIndices;
        this.numberOfSharedCacheSearchableSnapshotIndices = numberOfSharedCacheSearchableSnapshotIndices;
    }

    @Override
    protected void innerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.innerXContent(builder, params);
        builder.field("indices_count", this.numberOfSearchableSnapshotIndices);
        builder.field("full_copy_indices_count", this.numberOfFullCopySearchableSnapshotIndices);
        builder.field("shared_cache_indices_count", this.numberOfSharedCacheSearchableSnapshotIndices);
    }

    public int getNumberOfSearchableSnapshotIndices() {
        return this.numberOfSearchableSnapshotIndices;
    }

    public int getNumberOfFullCopySearchableSnapshotIndices() {
        return this.numberOfFullCopySearchableSnapshotIndices;
    }

    public int getNumberOfSharedCacheSearchableSnapshotIndices() {
        return this.numberOfSharedCacheSearchableSnapshotIndices;
    }

    public int hashCode() {
        return Objects.hash(this.available, this.enabled, this.numberOfSearchableSnapshotIndices, this.numberOfFullCopySearchableSnapshotIndices, this.numberOfSharedCacheSearchableSnapshotIndices);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SearchableSnapshotFeatureSetUsage other = (SearchableSnapshotFeatureSetUsage)obj;
        return this.available == other.available && this.enabled == other.enabled && this.numberOfSearchableSnapshotIndices == other.numberOfSearchableSnapshotIndices && this.numberOfFullCopySearchableSnapshotIndices == other.numberOfFullCopySearchableSnapshotIndices && this.numberOfSharedCacheSearchableSnapshotIndices == other.numberOfSharedCacheSearchableSnapshotIndices;
    }
}

