/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.profile.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.sandbox.search.ProfilerCollectorResult;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class CollectorResult
extends ProfilerCollectorResult
implements ToXContentObject,
Writeable {
    public static final String REASON_SEARCH_COUNT = "search_count";
    public static final String REASON_SEARCH_TOP_HITS = "search_top_hits";
    public static final String REASON_SEARCH_MULTI = "search_multi";
    public static final String REASON_SEARCH_QUERY_PHASE = "search_query_phase";
    public static final String REASON_AGGREGATION = "aggregation";
    public static final String REASON_AGGREGATION_GLOBAL = "aggregation_global";
    public static final ParseField NAME = new ParseField("name", new String[0]);
    public static final ParseField REASON = new ParseField("reason", new String[0]);
    public static final ParseField TIME = new ParseField("time", new String[0]);
    public static final ParseField TIME_NANOS = new ParseField("time_in_nanos", new String[0]);
    public static final ParseField CHILDREN = new ParseField("children", new String[0]);

    public CollectorResult(String collectorName, String reason, long time, List<CollectorResult> children) {
        super(collectorName, reason, Long.valueOf(time), new ArrayList<CollectorResult>(children));
    }

    public CollectorResult(StreamInput in) throws IOException {
        super(in.readString(), in.readString(), Long.valueOf(in.readLong()), in.readCollectionAsList(CollectorResult::new));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.getName());
        out.writeString(this.getReason());
        out.writeLong(this.getTime());
        out.writeCollection(this.getChildrenResults());
    }

    public List<CollectorResult> getChildrenResults() {
        return super.getProfiledChildren().stream().map(profilerCollectorResult -> (CollectorResult)profilerCollectorResult).toList();
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CollectorResult other = (CollectorResult)obj;
        return this.getName().equals(other.getName()) && this.getReason().equals(other.getReason()) && this.getTime() == other.getTime() && this.getChildrenResults().equals(other.getChildrenResults());
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getReason(), this.getTime(), this.getChildrenResults());
    }

    public String toString() {
        return Strings.toString(this);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder = builder.startObject();
        builder.field(NAME.getPreferredName(), this.getName());
        builder.field(REASON.getPreferredName(), this.getReason());
        if (builder.humanReadable()) {
            builder.field(TIME.getPreferredName(), new TimeValue(this.getTime(), TimeUnit.NANOSECONDS).toString());
        }
        builder.field(TIME_NANOS.getPreferredName(), this.getTime());
        if (!this.getProfiledChildren().isEmpty()) {
            builder = builder.startArray(CHILDREN.getPreferredName());
            for (CollectorResult child : this.getChildrenResults()) {
                builder = child.toXContent(builder, params);
            }
            builder = builder.endArray();
        }
        builder = builder.endObject();
        return builder;
    }
}

