/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.rank_eval;

import co.elastic.clients.elasticsearch.core.rank_eval.RankEvalHitItem;
import co.elastic.clients.elasticsearch.core.rank_eval.UnratedDocument;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class RankEvalMetricDetail
implements JsonpSerializable {
    private final double metricScore;
    private final List<UnratedDocument> unratedDocs;
    private final List<RankEvalHitItem> hits;
    private final Map<String, Map<String, JsonData>> metricDetails;
    public static final JsonpDeserializer<RankEvalMetricDetail> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RankEvalMetricDetail::setupRankEvalMetricDetailDeserializer);

    private RankEvalMetricDetail(Builder builder) {
        this.metricScore = ApiTypeHelper.requireNonNull(builder.metricScore, (Object)this, "metricScore", 0.0);
        this.unratedDocs = ApiTypeHelper.unmodifiableRequired(builder.unratedDocs, (Object)this, "unratedDocs");
        this.hits = ApiTypeHelper.unmodifiableRequired(builder.hits, (Object)this, "hits");
        this.metricDetails = ApiTypeHelper.unmodifiableRequired(builder.metricDetails, (Object)this, "metricDetails");
    }

    public static RankEvalMetricDetail of(Function<Builder, ObjectBuilder<RankEvalMetricDetail>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final double metricScore() {
        return this.metricScore;
    }

    public final List<UnratedDocument> unratedDocs() {
        return this.unratedDocs;
    }

    public final List<RankEvalHitItem> hits() {
        return this.hits;
    }

    public final Map<String, Map<String, JsonData>> metricDetails() {
        return this.metricDetails;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("metric_score");
        generator.write(this.metricScore);
        if (ApiTypeHelper.isDefined(this.unratedDocs)) {
            generator.writeKey("unrated_docs");
            generator.writeStartArray();
            for (UnratedDocument unratedDocument : this.unratedDocs) {
                unratedDocument.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.hits)) {
            generator.writeKey("hits");
            generator.writeStartArray();
            for (RankEvalHitItem rankEvalHitItem : this.hits) {
                rankEvalHitItem.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.metricDetails)) {
            generator.writeKey("metric_details");
            generator.writeStartObject();
            for (Map.Entry entry : this.metricDetails.entrySet()) {
                generator.writeKey((String)entry.getKey());
                generator.writeStartObject();
                if (entry.getValue() != null) {
                    for (Map.Entry item1 : ((Map)entry.getValue()).entrySet()) {
                        generator.writeKey((String)item1.getKey());
                        ((JsonData)item1.getValue()).serialize(generator, mapper);
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupRankEvalMetricDetailDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::metricScore, JsonpDeserializer.doubleDeserializer(), "metric_score");
        op.add(Builder::unratedDocs, JsonpDeserializer.arrayDeserializer(UnratedDocument._DESERIALIZER), "unrated_docs");
        op.add(Builder::hits, JsonpDeserializer.arrayDeserializer(RankEvalHitItem._DESERIALIZER), "hits");
        op.add(Builder::metricDetails, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER)), "metric_details");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<RankEvalMetricDetail> {
        private Double metricScore;
        private List<UnratedDocument> unratedDocs;
        private List<RankEvalHitItem> hits;
        private Map<String, Map<String, JsonData>> metricDetails;

        public final Builder metricScore(double value) {
            this.metricScore = value;
            return this;
        }

        public final Builder unratedDocs(List<UnratedDocument> list) {
            this.unratedDocs = Builder._listAddAll(this.unratedDocs, list);
            return this;
        }

        public final Builder unratedDocs(UnratedDocument value, UnratedDocument ... values) {
            this.unratedDocs = Builder._listAdd(this.unratedDocs, value, values);
            return this;
        }

        public final Builder unratedDocs(Function<UnratedDocument.Builder, ObjectBuilder<UnratedDocument>> fn) {
            return this.unratedDocs(fn.apply(new UnratedDocument.Builder()).build(), new UnratedDocument[0]);
        }

        public final Builder hits(List<RankEvalHitItem> list) {
            this.hits = Builder._listAddAll(this.hits, list);
            return this;
        }

        public final Builder hits(RankEvalHitItem value, RankEvalHitItem ... values) {
            this.hits = Builder._listAdd(this.hits, value, values);
            return this;
        }

        public final Builder hits(Function<RankEvalHitItem.Builder, ObjectBuilder<RankEvalHitItem>> fn) {
            return this.hits(fn.apply(new RankEvalHitItem.Builder()).build(), new RankEvalHitItem[0]);
        }

        public final Builder metricDetails(Map<String, Map<String, JsonData>> map) {
            this.metricDetails = Builder._mapPutAll(this.metricDetails, map);
            return this;
        }

        public final Builder metricDetails(String key, Map<String, JsonData> value) {
            this.metricDetails = Builder._mapPut(this.metricDetails, key, value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RankEvalMetricDetail build() {
            this._checkSingleUse();
            return new RankEvalMetricDetail(this);
        }
    }
}

