"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createTelemetryFilterListArtifactTaskConfig = createTelemetryFilterListArtifactTaskConfig;
var _artifact = require("../artifact");
var _filterlists = require("../filterlists");
var _helpers = require("../helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createTelemetryFilterListArtifactTaskConfig() {
  const taskName = 'Security Solution Telemetry Filter List Artifact Task';
  const taskType = 'security:telemetry-filterlist-artifact';
  return {
    type: taskType,
    title: taskName,
    interval: '45m',
    timeout: '1m',
    version: '1.0.0',
    runTask: async (taskId, logger, _receiver, _sender, taskMetricsService, taskExecutionPeriod) => {
      const mdc = {
        task_id: taskId,
        task_execution_period: taskExecutionPeriod
      };
      const log = (0, _helpers.newTelemetryLogger)(logger.get('filterlists'), mdc);
      const trace = taskMetricsService.start(taskType);
      log.debug('Running telemetry task');
      try {
        const artifactName = 'telemetry-filterlists-v1';
        const manifest = await _artifact.artifactService.getArtifact(artifactName);
        if (manifest.notModified) {
          log.debug('No new filterlist artifact found, skipping...');
          await taskMetricsService.end(trace);
          return 0;
        }
        const artifact = manifest.data;
        log.debug('New filterlist artifact', {
          artifact
        });
        _filterlists.filterList.endpointAlerts = artifact.endpoint_alerts;
        _filterlists.filterList.exceptionLists = artifact.exception_lists;
        _filterlists.filterList.prebuiltRulesAlerts = artifact.prebuilt_rules_alerts;
        await taskMetricsService.end(trace);
        return 0;
      } catch (error) {
        log.warn('Failed to set telemetry filterlist artifact', {
          error
        });
        _filterlists.filterList.resetAllToDefault();
        await taskMetricsService.end(trace, error);
        return 0;
      }
    }
  };
}