"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrateRuleState = exports.migrateRuleConfigSchema = void 0;
var _langgraph = require("@langchain/langgraph");
var _fp = require("lodash/fp");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const migrateRuleState = exports.migrateRuleState = _langgraph.Annotation.Root({
  id: (0, _langgraph.Annotation)(),
  original_rule: (0, _langgraph.Annotation)(),
  resources: (0, _langgraph.Annotation)(),
  elastic_rule: (0, _langgraph.Annotation)({
    reducer: (state, action) => ({
      ...state,
      ...action
    })
  }),
  semantic_query: (0, _langgraph.Annotation)({
    reducer: (current, value) => value !== null && value !== void 0 ? value : current,
    default: () => ''
  }),
  inline_query: (0, _langgraph.Annotation)({
    reducer: (current, value) => value !== null && value !== void 0 ? value : current,
    default: () => ''
  }),
  translation_result: (0, _langgraph.Annotation)(),
  comments: (0, _langgraph.Annotation)({
    // Translation subgraph causes the original main graph comments to be concatenated again, we need to deduplicate them.
    reducer: (current, value) => (0, _fp.uniq)(value ? (current !== null && current !== void 0 ? current : []).concat(value) : current),
    default: () => []
  }),
  nl_query: (0, _langgraph.Annotation)({
    reducer: (current, value) => value !== null && value !== void 0 ? value : current,
    default: () => ''
  }),
  messages: (0, _langgraph.Annotation)({
    reducer: _langgraph.messagesStateReducer,
    default: () => []
  })
});
const migrateRuleConfigSchema = exports.migrateRuleConfigSchema = _langgraph.Annotation.Root({
  skipPrebuiltRulesMatching: (0, _langgraph.Annotation)()
});