"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getResolveDepsNode = void 0;
var _comments = require("../../../../../common/task/util/comments");
var _prompts = require("./prompts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getResolveDepsNode = ({
  model
}) => {
  return async state => {
    var _state$messages;
    const modelWithTools = model;
    const query = state.original_rule.query;
    const resolveMessage = await _prompts.QRADAR_DEPENDENCIES_RESOLVE_PROMPT.formatMessages({
      title: state.original_rule.title,
      description: state.original_rule.description,
      query
    });
    const response = await modelWithTools.invoke([...resolveMessage, ...((_state$messages = state.messages) !== null && _state$messages !== void 0 ? _state$messages : [])]);
    const comments = [(0, _comments.generateAssistantComment)((0, _comments.cleanMarkdown)(response.text))];
    return {
      messages: [response],
      nl_query: response.text,
      comments
    };
  };
};
exports.getResolveDepsNode = getResolveDepsNode;