"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleMigrationsDataRulesClient = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _constants = require("../../../../../common/siem_migrations/constants");
var _constants2 = require("../../common/constants");
var _siem_migrations_data_item_client = require("../../common/data/siem_migrations_data_item_client");
var _constants3 = require("../../common/data/constants");
var _sort = require("./sort");
var _dsl_queries = require("./dsl_queries");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class RuleMigrationsDataRulesClient extends _siem_migrations_data_item_client.SiemMigrationsDataItemClient {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "type", 'rule');
  }
  /** Retrieves the translation stats for the rule migrations with the provided id */
  async getTranslationStats(migrationId) {
    var _result$aggregations, _doc_count, _doc_count2, _successAgg$installab, _doc_count3, _successAgg$prebuilt, _doc_count4, _successAgg$missing_i, _doc_count5, _aggs$failed;
    const index = await this.getIndexName();
    const query = this.getFilterQuery(migrationId);
    const aggregations = {
      success: {
        filter: {
          term: {
            status: _constants.SiemMigrationStatus.COMPLETED
          }
        },
        aggs: {
          result: {
            terms: {
              field: 'translation_result'
            }
          },
          installable: {
            filter: _dsl_queries.dsl.isInstallable()
          },
          prebuilt: {
            filter: _dsl_queries.dsl.isPrebuilt()
          },
          missing_index: {
            filter: _dsl_queries.dsl.isMissingIndex()
          }
        }
      },
      failed: {
        filter: {
          term: {
            status: _constants.SiemMigrationStatus.FAILED
          }
        }
      }
    };
    const result = await this.esClient.search({
      index,
      query,
      aggregations,
      _source: false
    }).catch(error => {
      this.logger.error(`Error getting rule migrations stats: ${error.message}`);
      throw error;
    });
    const aggs = (_result$aggregations = result.aggregations) !== null && _result$aggregations !== void 0 ? _result$aggregations : {};
    const total = this.getTotalHits(result);
    const successAgg = aggs.success;
    const translationResultsAgg = successAgg.result;
    return {
      id: migrationId,
      rules: {
        total,
        success: {
          total: (_doc_count = successAgg === null || successAgg === void 0 ? void 0 : successAgg.doc_count) !== null && _doc_count !== void 0 ? _doc_count : 0,
          result: this.translationResultAggCount(translationResultsAgg),
          installable: (_doc_count2 = (_successAgg$installab = successAgg.installable) === null || _successAgg$installab === void 0 ? void 0 : _successAgg$installab.doc_count) !== null && _doc_count2 !== void 0 ? _doc_count2 : 0,
          prebuilt: (_doc_count3 = (_successAgg$prebuilt = successAgg.prebuilt) === null || _successAgg$prebuilt === void 0 ? void 0 : _successAgg$prebuilt.doc_count) !== null && _doc_count3 !== void 0 ? _doc_count3 : 0,
          missing_index: (_doc_count4 = (_successAgg$missing_i = successAgg.missing_index) === null || _successAgg$missing_i === void 0 ? void 0 : _successAgg$missing_i.doc_count) !== null && _doc_count4 !== void 0 ? _doc_count4 : 0
        },
        failed: (_doc_count5 = (_aggs$failed = aggs.failed) === null || _aggs$failed === void 0 ? void 0 : _aggs$failed.doc_count) !== null && _doc_count5 !== void 0 ? _doc_count5 : 0
      }
    };
  }

  /** Retrieves the stats for the integrations of all the migration rules */
  async getAllIntegrationsStats() {
    var _result$aggregations2, _ref;
    const index = await this.getIndexName();
    const aggregations = {
      integrationIds: {
        terms: {
          field: 'elastic_rule.integration_ids',
          // aggregate by integration ids
          exclude: '',
          // excluding empty string integration ids
          size: _constants3.MAX_ES_SEARCH_SIZE
        }
      }
    };
    const result = await this.esClient.search({
      index,
      aggregations,
      _source: false
    }).catch(error => {
      this.logger.error(`Error getting all integrations stats: ${error.message}`);
      throw error;
    });
    const integrationsAgg = (_result$aggregations2 = result.aggregations) === null || _result$aggregations2 === void 0 ? void 0 : _result$aggregations2.integrationIds;
    const buckets = (_ref = integrationsAgg === null || integrationsAgg === void 0 ? void 0 : integrationsAgg.buckets) !== null && _ref !== void 0 ? _ref : [];
    return buckets.map(bucket => ({
      id: `${bucket.key}`,
      total_rules: bucket.doc_count
    }));
  }
  getFilterQuery(migrationId, filters = {}) {
    var _filters$searchTerm, _filters$titles;
    const {
      filter
    } = super.getFilterQuery(migrationId, filters).bool;

    // Rules specific filters
    if ((_filters$searchTerm = filters.searchTerm) !== null && _filters$searchTerm !== void 0 && _filters$searchTerm.length) {
      filter.push(_dsl_queries.dsl.matchTitle(filters.searchTerm));
    }
    if ((_filters$titles = filters.titles) !== null && _filters$titles !== void 0 && _filters$titles.length) {
      filter.push(_dsl_queries.dsl.matchTitles(filters.titles));
    }
    if (filters.installed != null) {
      filter.push(filters.installed ? _dsl_queries.dsl.isInstalled() : _dsl_queries.dsl.isNotInstalled());
    }
    if (filters.installable != null) {
      filter.push(filters.installable ? _dsl_queries.dsl.isInstallable() : _dsl_queries.dsl.isNotInstallable());
    }
    if (filters.prebuilt != null) {
      filter.push(filters.prebuilt ? _dsl_queries.dsl.isPrebuilt() : _dsl_queries.dsl.isCustom());
    }
    if (filters.missingIndex) {
      filter.push(_dsl_queries.dsl.isMissingIndex());
    }
    return {
      bool: {
        filter
      }
    };
  }
  getSortOptions(sort = {}) {
    return (0, _sort.getSortingOptions)(sort);
  }
  async updateIndexPattern(id, indexPattern, translatedRuleIds) {
    const index = await this.getIndexName();
    const additionalFilter = {
      missingIndex: true
    };
    if (translatedRuleIds) {
      additionalFilter.ids = translatedRuleIds;
    }
    const query = this.getFilterQuery(id, additionalFilter);
    const result = await this.esClient.updateByQuery({
      index,
      script: {
        source: `
                def originalQuery = ctx._source.elastic_rule.query;
                def newQuery = originalQuery.replace('${_constants2.MISSING_INDEX_PATTERN_PLACEHOLDER}', params.indexPattern);
                ctx._source.elastic_rule.query = newQuery;
              `,
        lang: 'painless',
        params: {
          indexPattern
        }
      },
      query,
      refresh: true
    }).catch(error => {
      this.logger.error(`Error updating index pattern for migration ${id}: ${error}`);
      throw error;
    });
    return result.updated;
  }
}
exports.RuleMigrationsDataRulesClient = RuleMigrationsDataRulesClient;