"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.riskScoreServiceFactory = void 0;
var _utils = require("../../../../common/entity_analytics/privileged_user_monitoring/utils");
var _constants = require("../../../../common/constants");
var _calculate_risk_scores = require("./calculate_risk_scores");
var _calculate_and_persist_risk_scores = require("./calculate_and_persist_risk_scores");
var _transforms = require("../utils/transforms");
var _calculate_esql_risk_scores = require("./calculate_esql_risk_scores");
var _reset_to_zero = require("./reset_to_zero");
var _privileged_users_crud = require("../privilege_monitoring/users/privileged_users_crud");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const riskScoreServiceFactory = ({
  assetCriticalityService,
  esClient,
  logger,
  riskEngineDataClient,
  riskScoreDataClient,
  spaceId,
  experimentalFeatures,
  uiSettingsClient
}) => {
  const privmonUserCrudService = (0, _privileged_users_crud.createPrivilegedUsersCrudService)({
    index: (0, _utils.getPrivilegedMonitorUsersIndex)(spaceId),
    esClient,
    logger
  });
  return {
    calculateScores: async params => {
      const isESQLRiskScoringAdvancedSettingEnabled = await uiSettingsClient.get(_constants.ENABLE_ESQL_RISK_SCORING);
      const calculate = !experimentalFeatures.disableESQLRiskScoring && isESQLRiskScoringAdvancedSettingEnabled ? _calculate_esql_risk_scores.calculateScoresWithESQL : _calculate_risk_scores.calculateRiskScores;
      return calculate({
        ...params,
        assetCriticalityService,
        privmonUserCrudService,
        esClient,
        logger,
        experimentalFeatures,
        filters: params.filters || []
      });
    },
    calculateAndPersistScores: params => (0, _calculate_and_persist_risk_scores.calculateAndPersistRiskScores)({
      ...params,
      assetCriticalityService,
      privmonUserCrudService,
      esClient,
      logger,
      riskScoreDataClient,
      spaceId,
      experimentalFeatures
    }),
    getConfigurationWithDefaults: async entityAnalyticsConfig => {
      var _savedObjectConfig$al;
      const savedObjectConfig = await riskEngineDataClient.getConfiguration();
      if (!savedObjectConfig) {
        return null;
      }
      const alertSampleSizePerShard = (_savedObjectConfig$al = savedObjectConfig.alertSampleSizePerShard) !== null && _savedObjectConfig$al !== void 0 ? _savedObjectConfig$al : entityAnalyticsConfig.riskEngine.alertSampleSizePerShard;
      return {
        ...savedObjectConfig,
        alertSampleSizePerShard
      };
    },
    resetToZero: async deps => {
      const results = await (0, _reset_to_zero.resetToZero)({
        ...deps,
        esClient,
        dataClient: riskScoreDataClient,
        spaceId,
        assetCriticalityService,
        logger
      });
      return results;
    },
    getRiskInputsIndex: async params => riskScoreDataClient.getRiskInputsIndex(params),
    scheduleLatestTransformNow: () => (0, _transforms.scheduleLatestTransformNow)({
      namespace: spaceId,
      esClient,
      logger
    }),
    refreshRiskScoreIndex: () => riskScoreDataClient.refreshRiskScoreIndex()
  };
};
exports.riskScoreServiceFactory = riskScoreServiceFactory;