"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.applyPrivmonModifier = void 0;
var _helpers = require("../helpers");
var _helpers2 = require("../../asset_criticality/helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// TODO: Tune modifier value
// QUESTION: This should take labels/sources/roles into account?
const PRIVILEGED_USER_MODIFIER = 2;
const applyPrivmonModifier = async ({
  page: {
    buckets,
    identifierField,
    bounds
  },
  deps,
  globalWeight,
  experimentalFeatures
}) => {
  if (buckets.length === 0) {
    return [];
  }
  if (!experimentalFeatures.enableRiskScorePrivmonModifier) {
    return buckets.map(() => ({
      category_3_score: 0,
      category_3_count: 0
    }));
  }
  const lower = bounds !== null && bounds !== void 0 && bounds.lower ? `${identifierField} > ${bounds.lower}` : undefined;
  const upper = bounds !== null && bounds !== void 0 && bounds.upper ? `${identifierField} <= ${bounds.upper}` : undefined;
  if (!lower && !upper) {
    throw new Error('Either lower or upper after key must be provided for pagination');
  }
  const rangeClauseKQL = !lower && !upper ? undefined : [lower, upper].filter(Boolean).join(' and ');
  const users = await deps.privmonUserCrudService.list(rangeClauseKQL).catch(error => {
    deps.logger.warn(`Error retrieving privileged users: ${error}. Scoring will proceed without privileged user information.`);
    return [];
  });
  return buckets.map(bucket => {
    const isPrivilegedUser = users.some(({
      user
    }) => (user === null || user === void 0 ? void 0 : user.name) === bucket.key[identifierField] && (user === null || user === void 0 ? void 0 : user.is_privileged));
    return calculateScoreAndContributions(bucket.top_inputs.risk_details.value.normalized_score, isPrivilegedUser, globalWeight);
  });
};
exports.applyPrivmonModifier = applyPrivmonModifier;
const calculateScoreAndContributions = (normalizedBaseScore, isPrivilegedUser, globalWeight) => {
  if (!isPrivilegedUser) {
    return {
      category_3_score: 0,
      category_3_count: 0
    };
  }
  const weightedNormalizedScore = globalWeight !== undefined ? normalizedBaseScore * globalWeight : normalizedBaseScore;
  const updatedNormalizedScore = (0, _helpers2.bayesianUpdate)({
    modifier: PRIVILEGED_USER_MODIFIER,
    score: weightedNormalizedScore
  });
  const contribution = updatedNormalizedScore - weightedNormalizedScore;
  return {
    category_3_score: (0, _helpers.max10DecimalPlaces)(contribution),
    category_3_count: 1,
    // modifier exists, so count as 1
    is_privileged_user: true,
    privileged_user_modifier: PRIVILEGED_USER_MODIFIER
  };
};