"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.max10DecimalPlaces = exports.isRiskScoreCalculationComplete = exports.getFieldForIdentifier = exports.getAfterKeyForIdentifierType = void 0;
var _types = require("../../../../common/entity_analytics/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFieldForIdentifier = identifierType => _types.EntityTypeToIdentifierField[identifierType];
exports.getFieldForIdentifier = getFieldForIdentifier;
const getAfterKeyForIdentifierType = ({
  afterKeys,
  identifierType
}) => afterKeys[identifierType];
exports.getAfterKeyForIdentifierType = getAfterKeyForIdentifierType;
const isRiskScoreCalculationComplete = result => {
  var _result$after_keys$ho, _result$after_keys$us, _result$after_keys$se;
  return Object.keys((_result$after_keys$ho = result.after_keys.host) !== null && _result$after_keys$ho !== void 0 ? _result$after_keys$ho : {}).length === 0 && Object.keys((_result$after_keys$us = result.after_keys.user) !== null && _result$after_keys$us !== void 0 ? _result$after_keys$us : {}).length === 0 && Object.keys((_result$after_keys$se = result.after_keys.service) !== null && _result$after_keys$se !== void 0 ? _result$after_keys$se : {}).length === 0;
};
exports.isRiskScoreCalculationComplete = isRiskScoreCalculationComplete;
const max10DecimalPlaces = num => Math.round(num * 1e10) / 1e10;
exports.max10DecimalPlaces = max10DecimalPlaces;