"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateSavedObjectAttribute = exports.initSavedObjects = exports.getDefaultRiskEngineConfiguration = exports.getConfiguration = exports.getAllSpaceConfigurations = exports.deleteSavedObjects = void 0;
var _utils = require("../../../../../common/entity_analytics/utils");
var _saved_object = require("../saved_object");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDefaultRiskEngineConfiguration = ({
  namespace
}) => ({
  dataViewId: (0, _utils.getAlertsIndex)(namespace),
  enabled: false,
  filter: {},
  identifierType: undefined,
  interval: '1h',
  pageSize: 3_500,
  range: {
    start: 'now-30d',
    end: 'now'
  },
  enableResetToZero: true,
  excludeAlertStatuses: ['closed'],
  _meta: {
    // Upgrade this property when changing mappings
    mappingsVersion: 5
  }
});
exports.getDefaultRiskEngineConfiguration = getDefaultRiskEngineConfiguration;
const getConfigurationSavedObject = async ({
  savedObjectsClient
}) => {
  var _savedObjectsResponse;
  const savedObjectsResponse = await savedObjectsClient.find({
    type: _saved_object.riskEngineConfigurationTypeName
  });
  return (_savedObjectsResponse = savedObjectsResponse.saved_objects) === null || _savedObjectsResponse === void 0 ? void 0 : _savedObjectsResponse[0];
};
const updateSavedObjectAttribute = async ({
  savedObjectsClient,
  attributes
}) => {
  const savedObjectConfiguration = await getConfigurationSavedObject({
    savedObjectsClient
  });
  if (!savedObjectConfiguration) {
    throw new Error('Risk engine configuration not found');
  }
  return savedObjectsClient.update(_saved_object.riskEngineConfigurationTypeName, savedObjectConfiguration.id, {
    ...attributes
  }, {
    refresh: 'wait_for'
  });
};
exports.updateSavedObjectAttribute = updateSavedObjectAttribute;
const initSavedObjects = async ({
  namespace,
  savedObjectsClient
}) => {
  const configuration = await getConfigurationSavedObject({
    savedObjectsClient
  });
  if (configuration) {
    return configuration;
  }
  return savedObjectsClient.create(_saved_object.riskEngineConfigurationTypeName, getDefaultRiskEngineConfiguration({
    namespace
  }), {});
};
exports.initSavedObjects = initSavedObjects;
const deleteSavedObjects = async ({
  savedObjectsClient
}) => {
  const configuration = await getConfigurationSavedObject({
    savedObjectsClient
  });
  if (configuration) {
    await savedObjectsClient.delete(_saved_object.riskEngineConfigurationTypeName, configuration.id);
  }
};
exports.deleteSavedObjects = deleteSavedObjects;
const getConfiguration = async ({
  savedObjectsClient
}) => {
  try {
    const savedObjectConfiguration = await getConfigurationSavedObject({
      savedObjectsClient
    });
    const configuration = savedObjectConfiguration === null || savedObjectConfiguration === void 0 ? void 0 : savedObjectConfiguration.attributes;
    if (configuration) {
      return configuration;
    }
    return null;
  } catch (e) {
    return null;
  }
};
exports.getConfiguration = getConfiguration;
const getAllSpaceConfigurations = async ({
  savedObjectsClient
}) => {
  const savedObjectsResponse = await savedObjectsClient.find({
    type: _saved_object.riskEngineConfigurationTypeName,
    namespaces: ['*']
  });
  return savedObjectsResponse.saved_objects;
};
exports.getAllSpaceConfigurations = getAllSpaceConfigurations;