"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteUserRoute = void 0;
var _utils = require("@kbn/lists-plugin/server/routes/utils");
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _utils2 = require("../../../../../../common/entity_analytics/privileged_user_monitoring/utils");
var _entity_analytics = require("../../../../../../common/api/entity_analytics");
var _constants = require("../../../../../../common/constants");
var _assert_advanced_setting_enabled = require("../../../utils/assert_advanced_setting_enabled");
var _privileged_users_crud = require("../../users/privileged_users_crud");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const deleteUserRoute = (router, logger) => {
  router.versioned.delete({
    access: 'public',
    path: `${_constants.MONITORING_USERS_URL}/{id}`,
    security: {
      authz: {
        requiredPrivileges: ['securitySolution', `${_constants.APP_ID}-entity-analytics`]
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: {
        params: _entity_analytics.DeletePrivMonUserRequestParams
      }
    }
  }, async (context, request, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    try {
      await (0, _assert_advanced_setting_enabled.assertAdvancedSettingsEnabled)(await context.core, _constants.ENABLE_PRIVILEGED_USER_MONITORING_SETTING);
      const secSol = await context.securitySolution;
      const {
        elasticsearch
      } = await context.core;
      const crudService = (0, _privileged_users_crud.createPrivilegedUsersCrudService)({
        esClient: elasticsearch.client.asCurrentUser,
        index: (0, _utils2.getPrivilegedMonitorUsersIndex)(secSol.getSpaceId()),
        logger: secSol.getLogger()
      });
      await crudService.delete(request.params.id);
      return response.ok({
        body: {
          acknowledged: true
        }
      });
    } catch (e) {
      const error = (0, _securitysolutionEsUtils.transformError)(e);
      logger.error(`Error deleting user: ${error.message}`);
      return siemResponse.error({
        statusCode: error.statusCode,
        body: error.message
      });
    }
  });
};
exports.deleteUserRoute = deleteUserRoute;