"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.logClusterShardFailuresEsql = void 0;
var i18n = _interopRequireWildcard(require("../translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const logClusterShardFailuresEsql = ({
  response,
  result
}) => {
  var _response$_clusters$d, _response$_clusters;
  const clusters = (_response$_clusters$d = response === null || response === void 0 ? void 0 : (_response$_clusters = response._clusters) === null || _response$_clusters === void 0 ? void 0 : _response$_clusters.details) !== null && _response$_clusters$d !== void 0 ? _response$_clusters$d : {};
  const shardFailures = Object.keys(clusters).reduce((acc, cluster) => {
    var _clusters$cluster$fai, _clusters$cluster;
    const failures = (_clusters$cluster$fai = (_clusters$cluster = clusters[cluster]) === null || _clusters$cluster === void 0 ? void 0 : _clusters$cluster.failures) !== null && _clusters$cluster$fai !== void 0 ? _clusters$cluster$fai : [];
    if (failures.length > 0) {
      acc.push(...failures);
    }
    return acc;
  }, []);
  if (shardFailures.length > 0) {
    result.warningMessages.push(i18n.ESQL_SHARD_FAILURE_MESSAGE(JSON.stringify(shardFailures)));
  }
};
exports.logClusterShardFailuresEsql = logClusterShardFailuresEsql;