"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getExportDetailsNdjson = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getExportDetailsNdjson = (rules, missingRuleIds = [], exceptionDetails, actionConnectorDetails) => {
  let exportedCount = rules.length;
  if (actionConnectorDetails != null) exportedCount += actionConnectorDetails.exported_action_connector_count;
  if (exceptionDetails != null) exportedCount += exceptionDetails.exported_exception_list_count + exceptionDetails.exported_exception_list_item_count;
  const stringified = {
    exported_count: exportedCount,
    exported_rules_count: rules.length,
    missing_rules: missingRuleIds.map(id => ({
      rule_id: id
    })),
    missing_rules_count: missingRuleIds.length,
    ...exceptionDetails,
    ...actionConnectorDetails
  };
  return `${JSON.stringify(stringified)}\n`;
};
exports.getExportDetailsNdjson = getExportDetailsNdjson;