"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.searchUnifiedAlertsRoute = void 0;
var _zodHelpers = require("@kbn/zod-helpers");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _unified_alerts = require("../../../../../common/api/detection_engine/unified_alerts");
var _constants = require("../../../../../common/constants");
var _search_alerts_handler = require("../common/search_alerts_handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const searchUnifiedAlertsRoute = (router, ruleDataClient) => {
  router.versioned.post({
    path: _constants.DETECTION_ENGINE_SEARCH_UNIFIED_ALERTS_URL,
    access: 'internal',
    security: {
      authz: {
        requiredPrivileges: ['securitySolution']
      }
    }
  }).addVersion({
    version: '1',
    validate: {
      request: {
        body: (0, _zodHelpers.buildRouteValidationWithZod)(_unified_alerts.SearchUnifiedAlertsRequestBody)
      }
    }
  }, async (context, request, response) => {
    const getIndexPattern = async () => {
      const spaceId = (await context.securitySolution).getSpaceId();
      const alertsIndex = ruleDataClient === null || ruleDataClient === void 0 ? void 0 : ruleDataClient.indexNameWithNamespace(spaceId);
      const indexPattern = [...(alertsIndex ? [alertsIndex] : []),
      // Detection alerts
      `${_elasticAssistantCommon.ATTACK_DISCOVERY_ALERTS_COMMON_INDEX_PREFIX}-${spaceId}` // Attack alerts
      ];
      return indexPattern;
    };
    return (0, _search_alerts_handler.searchAlertsHandler)({
      context,
      request,
      response,
      getIndexPattern
    });
  });
};
exports.searchUnifiedAlertsRoute = searchUnifiedAlertsRoute;