"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.querySignalsRoute = void 0;
var _zodHelpers = require("@kbn/zod-helpers");
var _signals = require("../../../../../common/api/detection_engine/signals");
var _constants = require("../../../../../common/constants");
var _search_alerts_handler = require("../common/search_alerts_handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const querySignalsRoute = (router, ruleDataClient) => {
  router.versioned.post({
    path: _constants.DETECTION_ENGINE_QUERY_SIGNALS_URL,
    access: 'public',
    security: {
      authz: {
        requiredPrivileges: ['securitySolution']
      }
    }
  }).addVersion({
    version: '2023-10-31',
    validate: {
      request: {
        body: (0, _zodHelpers.buildRouteValidationWithZod)(_signals.SearchAlertsRequestBody)
      }
    }
  }, async (context, request, response) => {
    const getIndexPattern = async () => {
      const spaceId = (await context.securitySolution).getSpaceId();
      const indexPattern = ruleDataClient === null || ruleDataClient === void 0 ? void 0 : ruleDataClient.indexNameWithNamespace(spaceId);
      return indexPattern;
    };
    return (0, _search_alerts_handler.searchAlertsHandler)({
      context,
      request,
      response,
      getIndexPattern
    });
  });
};
exports.querySignalsRoute = querySignalsRoute;