"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.installAssetInventoryDataViewRoute = void 0;
var _utils = require("@kbn/lists-plugin/server/routes/utils");
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _constants = require("../../../../common/api/asset_inventory/constants");
var _constants2 = require("../../../../common/constants");
var _errors = require("../errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const installAssetInventoryDataViewRoute = (router, logger) => {
  router.versioned.post({
    access: 'public',
    path: _constants.ASSET_INVENTORY_INSTALL_DATA_VIEW_API_PATH,
    security: {
      authz: {
        requiredPrivileges: ['securitySolution']
      }
    }
  }).addVersion({
    version: _constants2.API_VERSIONS.public.v1,
    validate: {
      request: {}
    }
  }, async (context, request, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    try {
      const secSol = await context.securitySolution;
      const body = await secSol.getAssetInventoryClient().installAssetInventoryDataView(secSol);
      return response.ok({
        body
      });
    } catch (e) {
      if (e instanceof Error && e.message === 'uiSetting') {
        return (0, _errors.errorInactiveFeature)(response);
      }
      const error = (0, _securitysolutionEsUtils.transformError)(e);
      logger.error(`Error installing asset inventory data view: ${error.message}`);
      return siemResponse.error({
        statusCode: error.statusCode,
        body: error.message
      });
    }
  });
};
exports.installAssetInventoryDataViewRoute = installAssetInventoryDataViewRoute;