"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedObjectsClientFactory = exports.InternalReadonlySoClientMethodNotAllowedError = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
var _coreHttpServerUtils = require("@kbn/core-http-server-utils");
var _common = require("@kbn/spaces-plugin/common");
var _reference_data = require("../../lib/reference_data");
var _errors = require("../../../../common/endpoint/errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable @typescript-eslint/no-explicit-any,max-classes-per-file */

const RESTRICTED_METHODS = ['bulkCreate', 'bulkUpdate', 'create', 'createPointInTimeFinder', 'delete', 'removeReferencesTo', 'update', 'updateObjectsSpaces'];
class InternalReadonlySoClientMethodNotAllowedError extends _errors.EndpointError {}

/**
 * Factory service for accessing saved object clients
 */
exports.InternalReadonlySoClientMethodNotAllowedError = InternalReadonlySoClientMethodNotAllowedError;
class SavedObjectsClientFactory {
  constructor(savedObjectsServiceStart, /** Can either be the  `HttpServiceSetup` or  `HttpServiceStart` or just an interface that hs a `basePath` implementation from core */
  httpServiceSetup) {
    this.savedObjectsServiceStart = savedObjectsServiceStart;
    this.httpServiceSetup = httpServiceSetup;
  }

  /**
   * Add a hidden Saved Object type to the list of types that should be given access by the SO clients created by the SavedObjectsClientFactory.
   * @param soType
   */
  static addSavedObjectHiddenType(soType) {
    this.includedHiddenTypes.add(soType);
  }
  createFakeHttpRequest(spaceId = _common.DEFAULT_SPACE_ID) {
    const fakeRequest = (0, _coreHttpServerUtils.kibanaRequestFactory)({
      headers: {},
      path: '/',
      route: {
        settings: {}
      },
      url: {
        href: {},
        hash: ''
      },
      raw: {
        req: {
          url: '/'
        }
      }
    });
    if (spaceId && spaceId !== _common.DEFAULT_SPACE_ID) {
      this.httpServiceSetup.basePath.set(fakeRequest, (0, _common.addSpaceIdToPath)('/', spaceId));
    }
    return fakeRequest;
  }
  getHiddenTypes() {
    return Array.from(this.constructor.includedHiddenTypes.values());
  }
  toReadonly(soClient) {
    return new Proxy(soClient, {
      get(target, methodName, receiver) {
        if (RESTRICTED_METHODS.includes(methodName)) {
          throw new InternalReadonlySoClientMethodNotAllowedError(`Method [${methodName}] not allowed on internal readonly SO Client`);
        }
        return Reflect.get(target, methodName, receiver);
      }
    });
  }

  /**
   * Creates a SavedObjects client that is scoped to a space (default: `Default`)
   */
  createInternalScopedSoClient({
    spaceId = _common.DEFAULT_SPACE_ID,
    readonly = true
  } = {}) {
    const soClient = this.savedObjectsServiceStart.getScopedClient(this.createFakeHttpRequest(spaceId), {
      excludedExtensions: [_coreSavedObjectsServer.SECURITY_EXTENSION_ID],
      includedHiddenTypes: this.getHiddenTypes()
    });
    if (readonly) {
      return this.toReadonly(soClient);
    }
    return soClient;
  }

  /**
   * Create a SavedObjects client that is un-scoped to a space and thus can access all
   * data across all spaces.
   *
   * **WARNING:** Use with care!
   */
  createInternalUnscopedSoClient(readonly = true) {
    const soClient = this.savedObjectsServiceStart.getScopedClient(this.createFakeHttpRequest(), {
      excludedExtensions: [_coreSavedObjectsServer.SECURITY_EXTENSION_ID, _coreSavedObjectsServer.SPACES_EXTENSION_ID],
      includedHiddenTypes: this.getHiddenTypes()
    });
    if (readonly) {
      return this.toReadonly(soClient);
    }
    return soClient;
  }
}
exports.SavedObjectsClientFactory = SavedObjectsClientFactory;
(0, _defineProperty2.default)(SavedObjectsClientFactory, "includedHiddenTypes", new Set([_reference_data.REFERENCE_DATA_SAVED_OBJECT_TYPE]));