"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getResponseActionFeatureKey = exports.FEATURE_KEYS = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FEATURE_KEYS = exports.FEATURE_KEYS = {
  HOST_ISOLATION: 'Host isolation',
  HOST_ISOLATION_EXCEPTION: 'Host isolation exception',
  HOST_ISOLATION_EXCEPTION_BY_POLICY: 'Host isolation exception by policy',
  TRUSTED_APP_BY_POLICY: 'Trusted app by policy',
  TRUSTED_DEVICE_BY_POLICY: 'Trusted device by policy',
  EVENT_FILTERS_BY_POLICY: 'Event filters by policy',
  BLOCKLIST_BY_POLICY: 'Blocklists by policy',
  RANSOMWARE_PROTECTION: 'Ransomeware protection',
  MEMORY_THREAT_PROTECTION: 'Memory threat protection',
  BEHAVIOR_PROTECTION: 'Behavior protection',
  KILL_PROCESS: 'Kill process',
  SUSPEND_PROCESS: 'Suspend process',
  RUNNING_PROCESSES: 'Get running processes',
  GET_FILE: 'Get file',
  UPLOAD: 'Upload file',
  EXECUTE: 'Execute command',
  SCAN: 'Scan files',
  RUN_SCRIPT: 'Run script',
  CANCEL: 'Cancel action',
  MEMORY_DUMP: 'Memory dump',
  ALERTS_BY_PROCESS_ANCESTRY: 'Get related alerts by process ancestry',
  ENDPOINT_EXCEPTIONS: 'Endpoint exceptions'
};
const RESPONSE_ACTIONS_FEATURE_KEY = {
  isolate: 'HOST_ISOLATION',
  unisolate: 'HOST_ISOLATION',
  'kill-process': 'KILL_PROCESS',
  'suspend-process': 'SUSPEND_PROCESS',
  'running-processes': 'RUNNING_PROCESSES',
  'get-file': 'GET_FILE',
  execute: 'EXECUTE',
  upload: 'UPLOAD',
  scan: 'SCAN',
  runscript: 'RUN_SCRIPT',
  cancel: 'CANCEL',
  'memory-dump': 'MEMORY_DUMP'
};
const getResponseActionFeatureKey = responseAction => {
  return RESPONSE_ACTIONS_FEATURE_KEY[responseAction];
};
exports.getResponseActionFeatureKey = getResponseActionFeatureKey;