"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerScriptsLibraryRoutes = void 0;
var _create_script = require("./create_script");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerScriptsLibraryRoutes = (router, endpointContext) => {
  if (endpointContext.experimentalFeatures.responseActionsScriptLibraryManagement) {
    endpointContext.logFactory.get('scriptsLibrary').debug('Registering scripts library routes');
    (0, _create_script.registerCreateScriptRoute)(router, endpointContext);
  }
};
exports.registerScriptsLibraryRoutes = registerScriptsLibraryRoutes;